/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Representation of an initiator Mapping
 */
@XmlRootElement(name = "initiatorMapping")
@XmlType(propOrder = {"id", "initiatorIqn", "targetIqn", "targetLun"})
public class InitiatorMappingDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.initiatormapping";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    private String initiatorIqn;

    private String targetIqn;

    private Integer targetLun;

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * IQN of the iSCSI initiator
     */
    @NotNull
    public String getInitiatorIqn()
    {
        return initiatorIqn;
    }

    public void setInitiatorIqn(final String initiatorIqn)
    {
        this.initiatorIqn = initiatorIqn;
    }

    /**
     * IQN of iSCSI the target
     */
    @NotNull
    public String getTargetIqn()
    {
        return targetIqn;
    }

    public void setTargetIqn(final String targetIqn)
    {
        this.targetIqn = targetIqn;
    }

    /**
     * LUN in the iSCSI the target accessible by the initiator
     */
    @NotNull
    public Integer getTargetLun()
    {
        return targetLun;
    }

    public void setTargetLun(final Integer targetLun)
    {
        this.targetLun = targetLun;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
