/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import static com.abiquo.model.transport.SingleResourceTransportDto.API_VERSION;
import static com.abiquo.model.transport.SingleResourceTransportDto.VERSION_PARAM;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.MovedPermanentlyDto;

/**
 * Representation of a moved volume
 * 
 * @author sacedo
 */
@XmlRootElement(name = "moved")
@XmlType(propOrder = {"volume"})
public class MovedVolumeDto extends MovedPermanentlyDto
{
    private static final String TYPE = "application/vnd.abiquo.moved";

    public static final String MEDIA_TYPE = TYPE + "+json";

    public static final String MEDIA_TYPE_XML = TYPE + "+xml" + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = TYPE + "+json" + VERSION_PARAM + API_VERSION;

    private VolumeManagementDto volume;

    /**
     * The moved volume
     * 
     * @output
     */
    public VolumeManagementDto getVolume()
    {
        return volume;
    }

    public void setVolume(final VolumeManagementDto volume)
    {
        this.volume = volume;
    }

}
