/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "device")
@XmlType(propOrder = {"id", "name", "storageTechnology", "managementIp", "managementPort",
"serviceIp", "servicePort", "username", "password"})
public class StorageDeviceDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.storagedevice";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private Integer id;

    private String name;

    private String storageTechnology;

    private String managementIp;

    private int managementPort;

    private String serviceIp;

    private int servicePort;

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Name of the storage device
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Technology type of the storage device
     */
    @NotNull
    public String getStorageTechnology()
    {
        return storageTechnology;
    }

    public void setStorageTechnology(final String storageTechnology)
    {
        this.storageTechnology = storageTechnology;
    }

    /**
     * Management IP of the storage device, used to connect to the management API
     */
    @NotNull
    public String getManagementIp()
    {
        return managementIp;
    }

    public void setManagementIp(final String managementIp)
    {
        this.managementIp = managementIp;
    }

    /**
     * Management port of the storage device, used to connect to the management API
     */
    @NotNull
    public int getManagementPort()
    {
        return managementPort;
    }

    public void setManagementPort(final int managementPort)
    {
        this.managementPort = managementPort;
    }

    /**
     * Service IP of the storage device, used by the hypervisors to connect to the device
     */
    @NotNull
    public String getServiceIp()
    {
        return serviceIp;
    }

    public void setServiceIp(final String serviceIp)
    {
        this.serviceIp = serviceIp;
    }

    /**
     * Service port of the storage device, used by the hypervisors to connect to the device
     */
    @NotNull
    public int getServicePort()
    {
        return servicePort;
    }

    public void setServicePort(final int servicePort)
    {
        this.servicePort = servicePort;
    }

    private String username;

    public void setUsername(final String username)
    {
        this.username = username;
    }

    /**
     * Username to connect to the management API, if any
     */
    public String getUsername()
    {
        return username;
    }

    private String password;

    public void setPassword(final String password)
    {
        this.password = password;
    }

    /**
     * Password to connect to the management API, if any
     */
    public String getPassword()
    {
        return password;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
