/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Metadata to describe the storage device.
 * 
 * @author Ignasi Barrera
 */
@XmlRootElement(name = "devicemetadata")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(propOrder = {"type", "defaultManagementPort", "defaultServicePort",
"requiresAuthentication"})
public class StorageDeviceMetadataDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.storagedevicemetadata";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** A unique name identifying the storage device type (e.g. NETAPP, LVM, etc). */
    private String type;

    /** Flag indicating if the API requires authentication. */
    private boolean requiresAuthentication;

    /** The default port for the management API. */
    private int defaultManagementPort;

    /** The default service port for the device. */
    private int defaultServicePort;

    /**
     * The storage technology type of the storage device
     * 
     * @output
     */
    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    /**
     * Boolean indicating if the storage device requires authentication
     * 
     * @output
     */
    public boolean isRequiresAuthentication()
    {
        return requiresAuthentication;
    }

    public void setRequiresAuthentication(final boolean requiresAuthentication)
    {
        this.requiresAuthentication = requiresAuthentication;
    }

    /**
     * The default port of the management API of the device
     * 
     * @output
     */
    public int getDefaultManagementPort()
    {
        return defaultManagementPort;
    }

    public void setDefaultManagementPort(final int defaultManagementPort)
    {
        this.defaultManagementPort = defaultManagementPort;
    }

    /**
     * The default service port of where the device listens
     * 
     * @output
     */
    public int getDefaultServicePort()
    {
        return defaultServicePort;
    }

    public void setDefaultServicePort(final int defaultServicePort)
    {
        this.defaultServicePort = defaultServicePort;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
