/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/* 
 * @restlink <link rel="tier" href="example.com/api/admin/datacenters/{id}/tiers/{id}"/>
 */
@XmlRootElement(name = "storagePool")
@XmlType(propOrder = {"idStorage", "name", "type", "totalSizeInMb", "usedSizeInMb",
"availableSizeInMb", "enabled", "maxVolumes", "usablePercent"})
public class StoragePoolDto extends SingleResourceTransportDto
{

    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.storagepool";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    protected String idStorage;

    protected String name;

    protected long totalSizeInMb;

    protected long usedSizeInMb;

    protected long availableSizeInMb;

    protected boolean enabled;

    protected String type;

    protected Integer maxVolumes;

    protected Integer usablePercent;

    /**
     * Identifier of the entity.
     */
    public String getIdStorage()
    {
        return idStorage;
    }

    public void setIdStorage(final String idStorage)
    {
        this.idStorage = idStorage;
    }

    /**
     * Name of the storage pool.
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Total size in MB of the storage pool.
     */
    @NotNull
    public long getTotalSizeInMb()
    {
        return totalSizeInMb;
    }

    public void setTotalSizeInMb(final long totalSizeInMb)
    {
        this.totalSizeInMb = totalSizeInMb;
    }

    /**
     * Used size in MB of the storage pool.
     */
    @NotNull
    public long getUsedSizeInMb()
    {
        return usedSizeInMb;
    }

    public void setUsedSizeInMb(final long usedSizeInMb)
    {
        this.usedSizeInMb = usedSizeInMb;
    }

    /**
     * Available size in MB of the storage pool.
     */
    @NotNull
    public long getAvailableSizeInMb()
    {
        return availableSizeInMb;
    }

    public void setAvailableSizeInMb(final long availableSizeInMb)
    {
        this.availableSizeInMb = availableSizeInMb;
    }

    /**
     * Returns true if the storage pool is enabled, false otherwise.
     * 
     * @output
     */
    public boolean getEnabled()
    {
        return enabled;
    }

    public void setEnabled(final boolean enabled)
    {
        this.enabled = enabled;
    }

    /**
     * The type of the storage pool, such as <code>ISCSI</code> or <code>NFS</code>.
     */
    @NotNull
    public String getType()
    {
        return type;
    }

    public void setType(final String type)
    {
        this.type = type;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    public Integer getMaxVolumes()
    {
        return maxVolumes;
    }

    public void setMaxVolumes(final Integer maxVolumes)
    {
        this.maxVolumes = maxVolumes;
    }

    public Integer getUsablePercent()
    {
        return usablePercent;
    }

    public void setUsablePercent(final Integer usablePercent)
    {
        this.usablePercent = usablePercent;
    }

}
