/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "tier")
@XmlType(propOrder = {"id", "name", "description", "enabled", "defaultAllowed",
"storageAllocationPolicy"})
public class TierDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.tier";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    private Integer id;

    private String name;

    private boolean enabled;

    private String description;

    private boolean defaultAllowed;

    private String storageAllocationPolicy;

    public TierDto()
    {
        super();
    }

    public String getStorageAllocationPolicy()
    {
        return storageAllocationPolicy;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Description of the tier
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * True if the tier is enabled, false otherwise
     */
    @NotNull
    public boolean getEnabled()
    {
        return enabled;
    }

    /**
     * Identifier of the tier
     */
    public Integer getId()
    {
        return id;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Name of the tier
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    /**
     * If tier is default allowed it will be allowed by default for the new enterprises
     */
    @NotNull
    public boolean isDefaultAllowed()
    {
        return defaultAllowed;
    }

    public void setStorageAllocationPolicy(final String storageAllocationPolicy)
    {
        this.storageAllocationPolicy = storageAllocationPolicy;
    }

    public void setDefaultAllowed(final boolean defaultAllowed)
    {
        this.defaultAllowed = defaultAllowed;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public void setEnabled(final boolean enabled)
    {
        this.enabled = enabled;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

}
