/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.storage;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "volume")
@XmlType(propOrder = {"id", "uuid", "name", "description", "state", "sizeInMB", "sequence",
"connection", "allowResize"})
public class VolumeManagementDto extends SingleResourceTransportDto
{
    public static final String TYPE = "application/vnd.abiquo.volume";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final String ISCSI_TYPE = "application/vnd.abiquo.iscsivolume";

    public static final String BASE_ISCSI_MEDIA_TYPE = ISCSI_TYPE + "+" + XML;

    public static final String ISCSI_MEDIA_TYPE_JSON = ISCSI_TYPE + "+" + JSON;

    public static final String ISCSI_MEDIA_TYPE = BASE_ISCSI_MEDIA_TYPE + VERSION_PARAM
        + API_VERSION;

    public static final String REL_PREFIX = DiskManagementDto.REL_PREFIX;

    private static final long serialVersionUID = 1L;

    private Integer id;

    private String uuid;

    private String name;

    private String description;

    private String state;

    private long sizeInMB;

    private Integer sequence;

    private String connection;

    private boolean allowResize;

    /**
     * Identifier of the entity
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Address for the volume in the target device. This field is required when creating generic
     * persistent volumes.
     */
    public String getConnection()
    {
        return connection;
    }

    public void setConnection(final String connection)
    {
        this.connection = connection;
    }

    /**
     * State of the volume (attached/detached)
     * 
     * @output
     */
    public String getState()
    {
        return state;
    }

    public void setState(final String state)
    {
        this.state = state;
    }

    /**
     * Unique universal identifier of the volume. This is the name of the volume in the target
     * storage device
     * 
     * @output
     */
    public String getUuid()
    {
        return uuid;
    }

    public void setUuid(final String uuid)
    {
        this.uuid = uuid;
    }

    /**
     * Name of the volume
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Size in MB of the volume
     */
    @NotNull
    public long getSizeInMB()
    {
        return sizeInMB;
    }

    public void setSizeInMB(final long sizeInMB)
    {
        this.sizeInMB = sizeInMB;
    }

    /**
     * The attachment order of this volume when attached to a virtual machine
     */
    public Integer getSequence()
    {
        return sequence;
    }

    public void setSequence(final Integer sequence)
    {
        this.sequence = sequence;
    }

    /**
     * Description of the volume
     */
    public String getDescription()
    {
        return description;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public boolean isAllowResize()
    {
        return allowResize;
    }

    public void setAllowResize(final boolean allowResize)
    {
        this.allowResize = allowResize;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
