/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v22;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "machinesToCreate")
public class MachinesToCreateDto22 extends SingleResourceTransportDto implements Serializable
{
    private static final long serialVersionUID = 1682439124759672513L;

    public static final String TYPE = "application/vnd.abiquo.multiplemachines+xml";

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    private String ipFrom;

    private String ipTo;

    private String hypervisor;

    private String user;

    private String password;

    private Integer port;

    private String vSwitch;

    public String getIpFrom()
    {
        return ipFrom;
    }

    public void setIpFrom(final String ipFrom)
    {
        this.ipFrom = ipFrom;
    }

    public String getIpTo()
    {
        return ipTo;
    }

    public void setIpTo(final String ipTo)
    {
        this.ipTo = ipTo;
    }

    public String getHypervisor()
    {
        return hypervisor;
    }

    public void setHypervisor(final String hypervisor)
    {
        this.hypervisor = hypervisor;
    }

    public String getUser()
    {
        return user;
    }

    public void setUser(final String user)
    {
        this.user = user;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(final String password)
    {
        this.password = password;
    }

    public Integer getPort()
    {
        return port;
    }

    public void setPort(final Integer port)
    {
        this.port = port;
    }

    public String getvSwitch()
    {
        return vSwitch;
    }

    public void setvSwitch(final String vSwitch)
    {
        this.vSwitch = vSwitch;
    }

    public MachinesToCreateDto22()
    {

    }

    public MachinesToCreateDto22(final String ipFrom, final String ipTo, final String hypervisor,
        final String user, final String password, final Integer port, final String vSwitch)
    {
        this.ipFrom = ipFrom;
        this.ipTo = ipTo;
        this.hypervisor = hypervisor;
        this.user = user;
        this.password = password;
        this.port = port;
        this.vSwitch = vSwitch;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_22;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }

}
