/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v22;

import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.MachineDto;
import com.abiquo.server.core.infrastructure.RackDto;

@XmlRootElement(name = "reservedMachine")
public class ReservedMachineDto22 extends MachineDto
{

    public static final String TYPE = "application/vnd.abiquo.reservedmachine+xml";

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    private DatacenterDto datacenter;

    private RackDto rack;

    public void setRack(final RackDto rack)
    {
        this.rack = rack;
    }

    /**
     * Rack of the physical machine
     * 
     * @return
     */
    public RackDto getRack()
    {
        return rack;
    }

    public void setDatacenter(final DatacenterDto datacenter)
    {
        this.datacenter = datacenter;
    }

    /**
     * Datacenter of the physical machine
     * 
     * @return
     */
    public DatacenterDto getDatacenter()
    {
        return datacenter;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_22;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }

}
