/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v24;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "device")
@XmlType(propOrder = {"id", "name", "storageTechnology", "managementIp", "managementPort",
"iscsiIp", "iscsiPort", "username", "password"})
public class StorageDeviceDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.storagedevice";

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML_24 = TYPE + "+" + XML + VERSION_PARAM
        + API_VERSION_24;

    private Integer id;

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private int managementPort;

    /**
     * Management port of the storage device, used to connect to the management API
     */
    @NotNull
    public int getManagementPort()
    {
        return managementPort;
    }

    public void setManagementPort(final int managementPort)
    {
        this.managementPort = managementPort;
    }

    private String name;

    /**
     * Name of the storage device
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private String iscsiIp;

    /**
     * iSCSI IP of the storage device, used by the hypervisors to connect to the device
     */
    @NotNull
    public String getIscsiIp()
    {
        return iscsiIp;
    }

    public void setIscsiIp(final String iscsiIp)
    {
        this.iscsiIp = iscsiIp;
    }

    private String storageTechnology;

    /**
     * Technology type of the storage device
     */
    @NotNull
    public String getStorageTechnology()
    {
        return storageTechnology;
    }

    public void setStorageTechnology(final String storageTechnology)
    {
        this.storageTechnology = storageTechnology;
    }

    private String managementIp;

    /**
     * Management IP of the storage device, used to connect to the management API
     */
    @NotNull
    public String getManagementIp()
    {
        return managementIp;
    }

    public void setManagementIp(final String managementIp)
    {
        this.managementIp = managementIp;
    }

    private int iscsiPort;

    /**
     * iSCSI port of the storage device, used by the hypervisors to connect to the device
     */
    @NotNull
    public int getIscsiPort()
    {
        return iscsiPort;
    }

    public void setIscsiPort(final int iscsiPort)
    {
        this.iscsiPort = iscsiPort;
    }

    private String username;

    public void setUsername(final String username)
    {
        this.username = username;
    }

    /**
     * Username to connect to the management API, if any
     */
    public String getUsername()
    {
        return username;
    }

    private String password;

    public void setPassword(final String password)
    {
        this.password = password;
    }

    /**
     * Password to connect to the management API, if any
     */
    public String getPassword()
    {
        return password;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_XML_24;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }
}
