/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v24;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.infrastructure.storage.DiskManagementDto;

@XmlRootElement(name = "volume")
@XmlType(propOrder = {"id", "uuid", "name", "description", "state", "sizeInMB", "sequence",
/* "availableSizeInMB", "usedSizeInMB", */"idScsi", "idImage"})
public class VolumeManagementDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.volume";

    private static final String ISCSI_TYPE = "application/vnd.abiquo.iscsivolume";

    public static final String BASE_ISCSI_MEDIA_TYPE = ISCSI_TYPE + "+" + XML;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    public static final String ISCSI_MEDIA_TYPE = BASE_ISCSI_MEDIA_TYPE + VERSION_PARAM
        + API_VERSION_24;

    public static final String REL_PREFIX = DiskManagementDto.REL_PREFIX;

    private static final long serialVersionUID = 1L;

    private Integer id;

    private String uuid;

    private String name;

    private String description;

    private String state;

    private long sizeInMB;

    private Integer sequence;

    // These fields are deprecated. We are only considering the whole volume size
    // private long availableSizeInMB;
    //
    // private long usedSizeInMB;

    private String idScsi;

    // TODO: vmahe. Replace this field by a link when the VirtualImage Resource is created
    private Integer idImage;

    /**
     * Identifier of the entity
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * iSCSI address for the volume in the target device. This field is required when creating
     * generic iSCSI volumes
     */
    public String getIdScsi()
    {
        return idScsi;
    }

    public void setIdScsi(final String idScsi)
    {
        this.idScsi = idScsi;
    }

    /**
     * State of the volume (attached/detached)
     * 
     * @output
     */
    public String getState()
    {
        return state;
    }

    public void setState(final String state)
    {
        this.state = state;
    }

    /**
     * Unique universal identifier of the volume. This is the name of the volume in the target
     * storage device
     * 
     * @output
     */
    public String getUuid()
    {
        return uuid;
    }

    public void setUuid(final String uuid)
    {
        this.uuid = uuid;
    }

    /**
     * Name of the volume
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    /**
     * Size in MB of the volume
     */
    @NotNull
    public long getSizeInMB()
    {
        return sizeInMB;
    }

    public void setSizeInMB(final long sizeInMB)
    {
        this.sizeInMB = sizeInMB;
    }

    /**
     * The attachment order of this volume when attached to a virtual machine
     */
    public Integer getSequence()
    {
        return sequence;
    }

    public void setSequence(final Integer sequence)
    {
        this.sequence = sequence;
    }

    /**
     * Description of the volume
     */
    public String getDescription()
    {
        return description;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    /**
     * Returns the identifier of the image if the volume is persistent, returns null otherwise
     * 
     * @output
     */
    public Integer getIdImage()
    {
        return idImage;
    }

    public void setIdImage(final Integer idImage)
    {
        this.idImage = idImage;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_24;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }
}
