/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v24;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualDatacenterWithDatacenterDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.infrastructure.storage.StoragePoolWithDeviceDto;

@XmlRootElement(name = "volumeWithVirtualMachine")
@XmlType(propOrder = {"virtualDatacenterWithDatacenter", "virtualAppliance", "virtualMachine",
"storagePoolWithDevice"})
public class VolumeManagementWithVirtualMachineDto extends VolumeManagementDto
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.iscsivolumewithvirtualmachine";

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    private VirtualMachineDto virtualMachine;

    private VirtualApplianceDto virtualAppliance;

    private VirtualDatacenterWithDatacenterDto virtualDatacenter;

    private StoragePoolWithDeviceDto storagePoolWithDevice;

    public void setVirtualMachine(final VirtualMachineDto virtualMachine)
    {
        this.virtualMachine = virtualMachine;
    }

    /**
     * Virtual machine where the volume is attached to
     * 
     * @output
     */
    public VirtualMachineDto getVirtualMachine()
    {
        return virtualMachine;
    }

    public void setVirtualDatacenterWithDatacenter(
        final VirtualDatacenterWithDatacenterDto virtualDatacenter)
    {
        this.virtualDatacenter = virtualDatacenter;
    }

    /**
     * Virtual datacenter where the volume is created in, also containing the datacenter where the
     * virtual datacenter belongs to
     * 
     * @output
     */
    public VirtualDatacenterWithDatacenterDto getVirtualDatacenterWithDatacenter()
    {
        return virtualDatacenter;
    }

    public void setStoragePoolWithDevice(final StoragePoolWithDeviceDto storagePoolWithDevice)
    {
        this.storagePoolWithDevice = storagePoolWithDevice;
    }

    /**
     * Storage pool where the volume is created in, also containing the device where the storage
     * pool belongs to
     * 
     * @output
     */
    public StoragePoolWithDeviceDto getStoragePoolWithDevice()
    {
        return storagePoolWithDevice;
    }

    public void setVirtualAppliance(final VirtualApplianceDto virtualAppliance)
    {
        this.virtualAppliance = virtualAppliance;
    }

    /**
     * Virtual appliance of the virtual machine where the volume is attached to
     * 
     * @output
     */
    public VirtualApplianceDto getVirtualAppliance()
    {
        return virtualAppliance;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_24;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }
}
