/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.infrastructure.v24;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.abiquo.model.transport.WrapperDto;

@XmlRootElement(name = "volumes")
public class VolumesManagementWithVirtualMachineDto extends
    WrapperDto<VolumeManagementWithVirtualMachineDto>
{
    private static final long serialVersionUID = 1L;

    private static final String TYPE = "application/vnd.abiquo.iscsivolumeswithvirtualmachine";

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_24 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_24;

    @Override
    @XmlElement(name = "volume")
    public List<VolumeManagementWithVirtualMachineDto> getCollection()
    {
        if (collection == null)
        {
            collection = new ArrayList<VolumeManagementWithVirtualMachineDto>();
        }
        return collection;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_24;
    }

    @Override
    public String getBaseMediaType()
    {
        return SHORT_MEDIA_TYPE_XML;
    }
}
