/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.pricing;

import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "pricingTemplate")
@XmlType(propOrder = {"id", "name", "description", "layer", "hdGB", "vlan", "vcpu", "memoryGB",
"repositoryGB", "publicIp", "minimumCharge", "showMinimumCharge", "showChangesBefore",
"minimumChargePeriod", "chargingPeriod", "standingChargePeriod", "defaultTemplate", "lastUpdate"})
public class PricingTemplateDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -6898276066732200634L;

    private static final String TYPE = "application/vnd.abiquo.pricingtemplate";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public PricingTemplateDto()
    {
    }

    public PricingTemplateDto(final String name, final BigDecimal hdGb,
        final BigDecimal standingChargePeriod, final BigDecimal vlan, final Integer chargingPeriod,
        final BigDecimal minimumChargePeriod, final boolean showChangesBefore,
        final Integer minimumCharge, final BigDecimal publicIp, final BigDecimal vCpu,
        final BigDecimal memoryGB, final boolean defaultTemplate, final String description,
        final BigDecimal layer, final BigDecimal repositoryGB)
    {
        this.name = name;
        this.hdGB = hdGb;
        this.standingChargePeriod = standingChargePeriod;
        this.vlan = vlan;
        this.chargingPeriod = chargingPeriod;
        this.minimumChargePeriod = minimumChargePeriod;
        this.showChangesBefore = showChangesBefore;
        this.minimumCharge = minimumCharge;
        this.publicIp = publicIp;
        this.vcpu = vCpu;
        this.memoryGB = memoryGB;
        this.description = description;
        this.lastUpdate = new Date();
        this.layer = layer;
        this.repositoryGB = repositoryGB;

    }

    private Integer id;

    /**
     * Identifier of the entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private String name;

    /**
     * The name of the pricing model
     */
    @NotNull
    public String getName()
    {
        return name;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    private String description;

    /**
     * The pricing estimate message
     */
    @NotNull
    public String getDescription()
    {
        return description;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    private BigDecimal hdGB;

    /**
     * Price of hypervisor datastores per gigabyte
     */
    @NotNull
    public BigDecimal getHdGB()
    {
        return hdGB;
    }

    public void setHdGB(final BigDecimal hdGB)
    {
        this.hdGB = hdGB;
    }

    private BigDecimal vcpu;

    /**
     * Price of CPU cores
     */
    @NotNull
    public BigDecimal getVcpu()
    {
        return vcpu;
    }

    public void setVcpu(final BigDecimal vcpu)
    {
        this.vcpu = vcpu;
    }

    private BigDecimal standingChargePeriod;

    /**
     * Standing charge per charging period
     */
    @NotNull
    public BigDecimal getStandingChargePeriod()
    {
        return standingChargePeriod;
    }

    public void setStandingChargePeriod(final BigDecimal standingChargePeriod)
    {
        this.standingChargePeriod = standingChargePeriod;
    }

    private BigDecimal vlan;

    /**
     * Price per VLAN
     */
    @NotNull
    public BigDecimal getVlan()
    {
        return vlan;
    }

    public void setVlan(final BigDecimal vlan)
    {
        this.vlan = vlan;
    }

    private boolean showMinimumCharge;

    public boolean isShowMinimumCharge()
    {
        return showMinimumCharge;
    }

    public void setShowMinimumCharge(final boolean showMinimumCharge)
    {
        this.showMinimumCharge = showMinimumCharge;
    }

    private Integer chargingPeriod;

    /**
     * Indicates the period of time to charge the user
     */
    @NotNull
    public Integer getChargingPeriod()
    {
        return chargingPeriod;
    }

    public void setChargingPeriod(final Integer chargingPeriod)
    {
        this.chargingPeriod = chargingPeriod;
    }

    private BigDecimal minimumChargePeriod;

    /**
     * Minimum charge per Minimum Period
     */
    @NotNull
    public BigDecimal getMinimumChargePeriod()
    {
        return minimumChargePeriod;
    }

    public void setMinimumChargePeriod(final BigDecimal minimumChargePeriod)
    {
        this.minimumChargePeriod = minimumChargePeriod;
    }

    private boolean showChangesBefore;

    /**
     * Indicates if show the charges before deployment
     */
    @NotNull
    public boolean isShowChangesBefore()
    {
        return showChangesBefore;
    }

    public void setShowChangesBefore(final boolean showChangesBefore)
    {
        this.showChangesBefore = showChangesBefore;
    }

    private Integer minimumCharge;

    /**
     * Indicates the minimum period of time that a user will be charged for
     */
    @NotNull
    public Integer getMinimumCharge()
    {
        return minimumCharge;
    }

    public void setMinimumCharge(final Integer minimumCharge)
    {
        this.minimumCharge = minimumCharge;
    }

    private BigDecimal publicIp;

    /**
     * Price per public IP address
     */
    @NotNull
    public BigDecimal getPublicIp()
    {
        return publicIp;
    }

    public void setPublicIp(final BigDecimal publicIp)
    {
        this.publicIp = publicIp;
    }

    private BigDecimal memoryGB;

    /**
     * Price of memory per megabyte
     */
    @NotNull
    public BigDecimal getMemoryGB()
    {
        return memoryGB;
    }

    public void setMemoryGB(final BigDecimal memoryGB)
    {
        this.memoryGB = memoryGB;
    }

    private BigDecimal layer;

    /**
     * Price of using antiaffinity capacity
     */
    @NotNull
    public BigDecimal getLayer()
    {
        return layer;
    }

    public void setLayer(final BigDecimal antiaffinity)
    {
        this.layer = antiaffinity;
    }

    private Date lastUpdate;

    /**
     * Indicates the last modification
     */
    @NotNull
    public Date getLastUpdate()
    {
        return lastUpdate;
    }

    public void setLastUpdate(final Date lastUpdate)
    {
        this.lastUpdate = lastUpdate;
    }

    private boolean defaultTemplate;

    public boolean isDefaultTemplate()
    {
        return defaultTemplate;
    }

    public void setDefaultTemplate(final boolean defaultTemplate)
    {
        this.defaultTemplate = defaultTemplate;
    }

    private BigDecimal repositoryGB;

    public BigDecimal getRepositoryGB()
    {
        return repositoryGB;
    }

    public void setRepositoryGB(final BigDecimal repositoryGB)
    {
        this.repositoryGB = repositoryGB;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }
}
