/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.statistics;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Shows statistics data on cloud usage filtered by datacenter such as:
 * <ol>
 * <li>Total number of enterprises</li>
 * <li>Total number of users</li>
 * <li>Total number of virtual datacenters</li>
 * <li>Total number of physical machines managed running or stopped</li>
 * <li>Total virtual machines managed: running / not running</li>
 * <li>External storage (in volumes defined in datacenter's storage section) used by virtual
 * machines: limits / total / currently running</li>
 * <li>Limits virtual CPU / Total virtual CPU including oversubscription rules effect / Used virtual
 * CPU (red)</li>
 * <li>Hard disk resources: Limits (yellow) / Total hard disk resources (green) / Used hard disk
 * resources (red)</li>
 * <li>RAM in virtual machines: Limits by enterprises / Total memory including oversubscription
 * rules effect / Used memory</li>
 * <li>Total enterprise limits for public IPs / Total public IPs created and available in all
 * datacenters / Total public IPs used (reserved or used by virtual machines)</li>
 * <li>Total number of VLANs in use by any datacenter managed</li>
 * </ol>
 * 
 * @author destevezg
 */
@XmlRootElement(name = "cloudusage")
@XmlType(propOrder = {"id", "numEnterprisesCreated", "numUsersCreated", "numVdcCreated",
"publicIPsReserved", "publicIPsTotal", "publicIPsUsed", "serversRunning", "serversTotal",
"storageReservedInMb", "storageReserved", "storageTotalInMb", "storageTotal", "storageUsedInMb",
"storageUsed", "virtualCpuReserved", "virtualCpuTotal", "virtualCpuUsed", "virtualMachinesRunning",
"virtualMachinesTotal", "virtualMemoryReservedInMb", "virtualMemoryReserved",
"virtualMemoryTotalInMb", "virtualMemoryTotal", "virtualMemoryUsedInMb", "virtualMemoryUsed",
"virtualStorageReservedInMb", "virtualStorageReserved", "virtualStorageTotalInMb",
"virtualStorageTotal", "virtualStorageUsedInMb", "virtualStorageUsed", "vlanUsed",
"repositoryUsedInMb", "repositoryUsed", "repositoryReservedInMb", "repositoryReserved"})
public class CloudUsageDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.cloudusage";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    private Integer id;

    /**
     * Identifier of the Entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private long virtualStorageTotalInMb;

    /**
     * Total storage size managed to be used by Virtual Machines in Megabytes
     * 
     * @output
     */
    public long getVirtualStorageTotalInMb()
    {
        return virtualStorageTotalInMb;
    }

    public void setVirtualStorageTotalInMb(final long virtualStorageTotalInMb)
    {
        this.virtualStorageTotalInMb = virtualStorageTotalInMb;
    }

    private long virtualMemoryReservedInMb;

    /**
     * Maximum amount of RAM reserved by all enterprises in Megabytes
     * 
     * @output
     */
    public long getVirtualMemoryReservedInMb()
    {
        return virtualMemoryReservedInMb;
    }

    public void setVirtualMemoryReservedInMb(final long virtualMemoryReservedInMb)
    {
        this.virtualMemoryReservedInMb = virtualMemoryReservedInMb;
    }

    private long storageTotalInMb;

    /**
     * External storage managed by Abiquo (in Megabytes)
     * 
     * @output
     */
    public long getStorageTotalInMb()
    {
        return storageTotalInMb;
    }

    public void setStorageTotalInMb(final long storageTotalInMb)
    {
        this.storageTotalInMb = storageTotalInMb;
    }

    private long virtualMemoryUsedInMb;

    /**
     * Total amount of RAM used by Virtual Machines currently in a running state in Megabytes
     * 
     * @output
     */
    public long getVirtualMemoryUsedInMb()
    {
        return virtualMemoryUsedInMb;
    }

    public void setVirtualMemoryUsedInMb(final long virtualMemoryUsedInMb)
    {
        this.virtualMemoryUsedInMb = virtualMemoryUsedInMb;
    }

    private long virtualCpuTotal;

    /**
     * Total number of Virtual CPUs in Virtual Machines currently in a running state
     * 
     * @output
     */
    public long getVirtualCpuTotal()
    {
        return virtualCpuTotal;
    }

    public void setVirtualCpuTotal(final long virtualCpuTotal)
    {
        this.virtualCpuTotal = virtualCpuTotal;
    }

    private long publicIPsUsed;

    /**
     * Total number of IPs used by virtual machines
     * 
     * @output
     */
    public long getPublicIPsUsed()
    {
        return publicIPsUsed;
    }

    public void setPublicIPsUsed(final long publicIPsUsed)
    {
        this.publicIPsUsed = publicIPsUsed;
    }

    private long publicIPsReserved;

    /**
     * Total number of IPs assigned to a VirtualDatacenter (Reserved)
     * 
     * @output
     */
    public long getPublicIPsReserved()
    {
        return publicIPsReserved;
    }

    public void setPublicIPsReserved(final long publicIPsReserved)
    {
        this.publicIPsReserved = publicIPsReserved;
    }

    private long storageUsedInMb;

    /**
     * External storage used (attached or mounted) by any virtual machines (in Megabytes)
     * 
     * @output
     */
    public long getStorageUsedInMb()
    {
        return storageUsedInMb;
    }

    public void setStorageUsedInMb(final long storageUsedInMb)
    {
        this.storageUsedInMb = storageUsedInMb;
    }

    private long storageReservedInMb;

    /**
     * External storage reserved by Enterprises in Datacenters (in Megabytes)
     * 
     * @output
     */
    public long getStorageReservedInMb()
    {
        return storageReservedInMb;
    }

    public void setStorageReservedInMb(final long storageReservedInMb)
    {
        this.storageReservedInMb = storageReservedInMb;
    }

    private long serversTotal;

    /**
     * Total number of Physical machines managed
     * 
     * @output
     */
    public long getServersTotal()
    {
        return serversTotal;
    }

    public void setServersTotal(final long serversTotal)
    {
        this.serversTotal = serversTotal;
    }

    private long publicIPsTotal;

    /**
     * Total number of IPs defined (managed)
     * 
     * @output
     */
    public long getPublicIPsTotal()
    {
        return publicIPsTotal;
    }

    public void setPublicIPsTotal(final long publicIPsTotal)
    {
        this.publicIPsTotal = publicIPsTotal;
    }

    private long virtualStorageUsedInMb;

    /**
     * Total storage size used by Virtual Machines currently in a running state in Megabytes
     * 
     * @output
     */
    public long getVirtualStorageUsedInMb()
    {
        return virtualStorageUsedInMb;
    }

    public void setVirtualStorageUsedInMb(final long virtualStorageUsedInMb)
    {
        this.virtualStorageUsedInMb = virtualStorageUsedInMb;
    }

    private long vlanUsed;

    /**
     * Total number of VLANs in use by any datacenter managed
     * 
     * @output
     */
    public long getVlanUsed()
    {
        return vlanUsed;
    }

    public void setVlanUsed(final long vlanUsed)
    {
        this.vlanUsed = vlanUsed;
    }

    private long numVdcCreated;

    /**
     * Total number of Virtual DataCenters in system
     * 
     * @output
     */
    public long getNumVdcCreated()
    {
        return numVdcCreated;
    }

    public void setNumVdcCreated(final long numVdcCreated)
    {
        this.numVdcCreated = numVdcCreated;
    }

    private long numEnterprisesCreated;

    /**
     * Total number of enterprises in system
     * 
     * @output
     */
    public long getNumEnterprisesCreated()
    {
        return numEnterprisesCreated;
    }

    public void setNumEnterprisesCreated(final long numEnterprisesCreated)
    {
        this.numEnterprisesCreated = numEnterprisesCreated;
    }

    private long virtualStorageReservedInMb;

    /**
     * Maximum storage size reserved by all enterprises for Virtual Machines in Megabytes
     * 
     * @output
     */
    public long getVirtualStorageReservedInMb()
    {
        return virtualStorageReservedInMb;
    }

    public void setVirtualStorageReservedInMb(final long virtualStorageReservedInMb)
    {
        this.virtualStorageReservedInMb = virtualStorageReservedInMb;
    }

    private long virtualMemoryTotalInMb;

    /**
     * Total amount of RAM managed (can be used for VMs) in Megabytes
     * 
     * @output
     */
    public long getVirtualMemoryTotalInMb()
    {
        return virtualMemoryTotalInMb;
    }

    public void setVirtualMemoryTotalInMb(final long virtualMemoryTotalInMb)
    {
        this.virtualMemoryTotalInMb = virtualMemoryTotalInMb;
    }

    private long virtualCpuUsed;

    /**
     * Total number of Virtual CPUs in Virtual Machines currently in a running state
     * 
     * @output
     */
    public long getVirtualCpuUsed()
    {
        return virtualCpuUsed;
    }

    public void setVirtualCpuUsed(final long virtualCpuUsed)
    {
        this.virtualCpuUsed = virtualCpuUsed;
    }

    private long virtualCpuReserved;

    /**
     * Maximum number of Virtual CPUs reserved by all enterprises
     * 
     * @output
     */
    public long getVirtualCpuReserved()
    {
        return virtualCpuReserved;
    }

    public void setVirtualCpuReserved(final long virtualCpuReserved)
    {
        this.virtualCpuReserved = virtualCpuReserved;
    }

    private long virtualMachinesTotal;

    /**
     * Total number of Virtual Machines managed
     * 
     * @output
     */
    public long getVirtualMachinesTotal()
    {
        return virtualMachinesTotal;
    }

    public void setVirtualMachinesTotal(final long virtualMachinesTotal)
    {
        this.virtualMachinesTotal = virtualMachinesTotal;
    }

    private long serversRunning;

    /**
     * Total number of Physical Machines running currently
     * 
     * @output
     */
    public long getServersRunning()
    {
        return serversRunning;
    }

    public void setServersRunning(final long serversRunning)
    {
        this.serversRunning = serversRunning;
    }

    private long numUsersCreated;

    /**
     * Total number of users in system
     * 
     * @output
     */
    public long getNumUsersCreated()
    {
        return numUsersCreated;
    }

    public void setNumUsersCreated(final long numUsersCreated)
    {
        this.numUsersCreated = numUsersCreated;
    }

    private long virtualMachinesRunning;

    /**
     * Total number of Virtual Machines currently in a running state
     * 
     * @output
     */
    public long getVirtualMachinesRunning()
    {
        return virtualMachinesRunning;
    }

    public void setVirtualMachinesRunning(final long virtualMachinesRunning)
    {
        this.virtualMachinesRunning = virtualMachinesRunning;
    }

    /**
     * Total amount of Repository used
     * 
     * @output
     */
    private long repositoryUsedInMb;

    public long getRepositoryUsedInMb()
    {
        return repositoryUsedInMb;
    }

    public void setRepositoryUsedInMb(final long repositoryUsedInMb)
    {
        this.repositoryUsedInMb = repositoryUsedInMb;
    }

    private long repositoryReservedInMb;

    /**
     * Total amount of repository Reserved by all enterprises
     * 
     * @output
     */
    public long getRepositoryReservedInMb()
    {
        return repositoryReservedInMb;
    }

    public void setRepositoryReservedInMb(final long repositoryReservedInMb)
    {
        this.repositoryReservedInMb = repositoryReservedInMb;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Deprecated
    private long repositoryReserved;

    @Deprecated
    private long repositoryUsed;

    @Deprecated
    private long storageReserved;

    @Deprecated
    private long storageTotal;

    @Deprecated
    private long storageUsed;

    @Deprecated
    private long virtualMemoryReserved;

    @Deprecated
    private long virtualMemoryTotal;

    @Deprecated
    private long virtualMemoryUsed;

    private long virtualStorageReserved;

    private long virtualStorageTotal;

    private long virtualStorageUsed;

    @Deprecated
    public long getRepositoryReserved()
    {
        return repositoryReserved;
    }

    @Deprecated
    public void setRepositoryReserved(final long repositoryReserved)
    {
        this.repositoryReserved = repositoryReserved;
    }

    @Deprecated
    public long getRepositoryUsed()
    {
        return repositoryUsed;
    }

    @Deprecated
    public void setRepositoryUsed(final long repositoryUsed)
    {
        this.repositoryUsed = repositoryUsed;
    }

    @Deprecated
    public long getStorageReserved()
    {
        return storageReserved;
    }

    @Deprecated
    public void setStorageReserved(final long storageReserved)
    {
        this.storageReserved = storageReserved;
    }

    @Deprecated
    public long getStorageTotal()
    {
        return storageTotal;
    }

    @Deprecated
    public void setStorageTotal(final long storageTotal)
    {
        this.storageTotal = storageTotal;
    }

    @Deprecated
    public long getStorageUsed()
    {
        return storageUsed;
    }

    @Deprecated
    public void setStorageUsed(final long storageUsed)
    {
        this.storageUsed = storageUsed;
    }

    @Deprecated
    public long getVirtualMemoryReserved()
    {
        return virtualMemoryReserved;
    }

    @Deprecated
    public void setVirtualMemoryReserved(final long virtualMemoryReserved)
    {
        this.virtualMemoryReserved = virtualMemoryReserved;
    }

    @Deprecated
    public long getVirtualMemoryTotal()
    {
        return virtualMemoryTotal;
    }

    @Deprecated
    public void setVirtualMemoryTotal(final long virtualMemoryTotal)
    {
        this.virtualMemoryTotal = virtualMemoryTotal;
    }

    @Deprecated
    public long getVirtualMemoryUsed()
    {
        return virtualMemoryUsed;
    }

    @Deprecated
    public void setVirtualMemoryUsed(final long virtualMemoryUsed)
    {
        this.virtualMemoryUsed = virtualMemoryUsed;
    }

    @Deprecated
    public long getVirtualStorageReserved()
    {
        return virtualStorageReserved;
    }

    @Deprecated
    public void setVirtualStorageReserved(final long virtualStorageReserved)
    {
        this.virtualStorageReserved = virtualStorageReserved;
    }

    @Deprecated
    public long getVirtualStorageTotal()
    {
        return virtualStorageTotal;
    }

    @Deprecated
    public void setVirtualStorageTotal(final long virtualStorageTotal)
    {
        this.virtualStorageTotal = virtualStorageTotal;
    }

    @Deprecated
    public long getVirtualStorageUsed()
    {
        return virtualStorageUsed;
    }

    @Deprecated
    public void setVirtualStorageUsed(final long virtualStorageUsed)
    {
        this.virtualStorageUsed = virtualStorageUsed;
    }

}
