/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.statistics;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * Shows statistical data on resources used by enterprises, such as:
 * <ol>
 * <li>Virtual CPUs used by the virtual machines (total and currently running)</li>
 * <li>Storage size (total and used) of disks used by virtual machines (total and currently running)
 * </li>
 * <li>RAM used by the virtual machines (total and currently running)</li>
 * <li>External storage (in volumes defined in the datacenter's storage section) used by virtual
 * machines (total and currently running)</li>
 * <li>Total and used number of VLANs defined</li>
 * <li>Total, reserved and used number of public IPs</li>
 * </ol>
 * 
 * @author destevezg
 */
@XmlRootElement(name = "enterpriseresources")
@XmlType(propOrder = {"id", "extStorageReservedInMb", "extStorageReserved", "extStorageUsedInMb",
"extStorageUsed", "localStorageReservedInMb", "localStorageReserved", "localStorageUsedInMb",
"localStorageUsed", "memoryReservedInMb", "memoryReserved", "memoryUsedInMb", "memoryUsed",
"publicIPsLimit", "publicIPsReserved", "publicIPsUsed", "repositoryReservedInMb",
"repositoryReserved", "repositoryUsedInMb", "repositoryUsed", "virtualCpuReserved",
"virtualCpuUsed", "vlanReserved", "vlanUsed"})
public class EnterpriseResourcesDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = -6456428269555885499L;

    private static final String TYPE = "application/vnd.abiquo.enterpriseresources";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    private Integer id;

    /**
     * Identifier of the Entity
     * 
     * @output
     */
    public Integer getId()
    {
        return id;
    }

    public void setId(final Integer id)
    {
        this.id = id;
    }

    private long repositoryReservedInMb;

    /**
     * Maximum repository size reserved for this enterprise in Megabytes
     * 
     * @output
     */
    public long getRepositoryReservedInMb()
    {
        return repositoryReservedInMb;
    }

    public void setRepositoryReservedInMb(final long repositoryReservedInMb)
    {
        this.repositoryReservedInMb = repositoryReservedInMb;
    }

    private long memoryReservedInMb;

    /**
     * Maximum amount of RAM reserved for this enterprise in Megabytes
     * 
     * @output
     */
    public long getMemoryReservedInMb()
    {
        return memoryReservedInMb;
    }

    public void setMemoryReservedInMb(final long memoryReservedInMb)
    {
        this.memoryReservedInMb = memoryReservedInMb;
    }

    private long vlanReserved;

    /**
     * Total maximum number of VLANs reserved for this enterprise. (enterprise.vlanHard)
     * 
     * @output
     */
    public long getVlanReserved()
    {
        return vlanReserved;
    }

    public void setVlanReserved(final long vlanReserved)
    {
        this.vlanReserved = vlanReserved;
    }

    private long publicIPsUsed;

    /**
     * Total number of IPs used by virtual machines
     * 
     * @output
     */
    public long getPublicIPsUsed()
    {
        return publicIPsUsed;
    }

    public void setPublicIPsUsed(final long publicIPsUsed)
    {
        this.publicIPsUsed = publicIPsUsed;
    }

    private long publicIPsReserved;

    /**
     * Total number of IPs assigned to a VirtualDatacenter (Reserved)
     * 
     * @output
     */
    public long getPublicIPsReserved()
    {
        return publicIPsReserved;
    }

    public void setPublicIPsReserved(final long publicIPsReserved)
    {
        this.publicIPsReserved = publicIPsReserved;
    }

    private long publicIPsLimit;

    /**
     * Maximum amount of public ips this enterprise can reserve
     * 
     * @param publicIPsLimit
     */

    public void setPublicIPsLimit(final long publicIPsLimit)
    {
        this.publicIPsLimit = publicIPsLimit;
    }

    public long getPublicIPsLimit()
    {
        return publicIPsLimit;
    }

    private long localStorageReservedInMb;

    /**
     * Maximum storage size reserved for this enterprise for Virtual Machines in Megabytes
     * 
     * @output
     */

    public long getLocalStorageReservedInMb()
    {
        return localStorageReservedInMb;
    }

    public void setLocalStorageReservedInMb(final long localStorageReservedInMb)
    {
        this.localStorageReservedInMb = localStorageReservedInMb;
    }

    private long extStorageUsedInMb;

    /**
     * Storage in external storage volumes used (attached or mounted) by any virtual machines (in
     * Megabytes)
     * 
     * @output
     */
    public long getExtStorageUsedInMb()
    {
        return extStorageUsedInMb;
    }

    public void setExtStorageUsedInMb(final long extStorageUsedInMb)
    {
        this.extStorageUsedInMb = extStorageUsedInMb;
    }

    private long vlanUsed;

    /**
     * Total number of VLANs in use by any datacenter managed
     * 
     * @output
     */

    public long getVlanUsed()
    {
        return vlanUsed;
    }

    public void setVlanUsed(final long vlanUsed)
    {
        this.vlanUsed = vlanUsed;
    }

    private long extStorageReservedInMb;

    /**
     * Maximum external storage size reserved for this enterprise in Megabytes
     * 
     * @output
     */

    public long getExtStorageReservedInMb()
    {
        return extStorageReservedInMb;
    }

    public void setExtStorageReservedInMb(final long extStorageReservedInMb)
    {
        this.extStorageReservedInMb = extStorageReservedInMb;
    }

    private long localStorageUsedInMb;

    /**
     * Total storage size used by Virtual Machines currently in a running state in Megabytes
     * 
     * @output
     */

    public long getLocalStorageUsedInMb()
    {
        return localStorageUsedInMb;
    }

    public void setLocalStorageUsedInMb(final long localStorageUsedInMb)
    {
        this.localStorageUsedInMb = localStorageUsedInMb;
    }

    private long virtualCpuUsed;

    /**
     * Total number of Virtual CPUs in Virtual Machines currently in a running state
     * 
     * @output
     */

    public long getVirtualCpuUsed()
    {
        return virtualCpuUsed;
    }

    public void setVirtualCpuUsed(final long virtualCpuUsed)
    {
        this.virtualCpuUsed = virtualCpuUsed;
    }

    private long virtualCpuReserved;

    /**
     * Maximum number of Virtual CPUs reserved for this enterprise
     * 
     * @output
     */

    public long getVirtualCpuReserved()
    {
        return virtualCpuReserved;
    }

    public void setVirtualCpuReserved(final long virtualCpuReserved)
    {
        this.virtualCpuReserved = virtualCpuReserved;
    }

    private long repositoryUsedInMb;

    /**
     * Total repository size currently used for this enterprise in Megabytes
     * 
     * @output
     */

    public long getRepositoryUsedInMb()
    {
        return repositoryUsedInMb;
    }

    public void setRepositoryUsedInMb(final long repositoryUsedInMb)
    {
        this.repositoryUsedInMb = repositoryUsedInMb;
    }

    private long memoryUsedInMb;

    /**
     * Total amount of RAM used by Virtual Machines currently in a running state in Megabytes
     * 
     * @output
     */
    public long getMemoryUsedInMb()
    {
        return memoryUsedInMb;
    }

    public void setMemoryUsedInMb(final long memoryUsedInMb)
    {
        this.memoryUsedInMb = memoryUsedInMb;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Deprecated
    private long repositoryReserved;

    @Deprecated
    private long repositoryUsed;

    @Deprecated
    private long memoryUsed;

    @Deprecated
    private long memoryReserved;

    @Deprecated
    private long localStorageUsed;

    @Deprecated
    private long localStorageReserved;

    @Deprecated
    private long extStorageUsed;

    @Deprecated
    private long extStorageReserved;

    @Deprecated
    public long getRepositoryReserved()
    {
        return repositoryReserved;
    }

    @Deprecated
    public void setRepositoryReserved(final long repositoryReserved)
    {
        this.repositoryReserved = repositoryReserved;
    }

    @Deprecated
    public long getRepositoryUsed()
    {
        return repositoryUsed;
    }

    @Deprecated
    public void setRepositoryUsed(final long repositoryUsed)
    {
        this.repositoryUsed = repositoryUsed;
    }

    @Deprecated
    public long getMemoryUsed()
    {
        return memoryUsed;
    }

    @Deprecated
    public void setMemoryUsed(final long memoryUsed)
    {
        this.memoryUsed = memoryUsed;
    }

    @Deprecated
    public long getMemoryReserved()
    {
        return memoryReserved;
    }

    @Deprecated
    public void setMemoryReserved(final long memoryReserved)
    {
        this.memoryReserved = memoryReserved;
    }

    @Deprecated
    public long getLocalStorageUsed()
    {
        return localStorageUsed;
    }

    @Deprecated
    public void setLocalStorageUsed(final long localStorageUsed)
    {
        this.localStorageUsed = localStorageUsed;
    }

    @Deprecated
    public long getLocalStorageReserved()
    {
        return localStorageReserved;
    }

    @Deprecated
    public void setLocalStorageReserved(final long localStorageReserved)
    {
        this.localStorageReserved = localStorageReserved;
    }

    @Deprecated
    public long getExtStorageUsed()
    {
        return extStorageUsed;
    }

    @Deprecated
    public void setExtStorageUsed(final long extStorageUsed)
    {
        this.extStorageUsed = extStorageUsed;
    }

    @Deprecated
    public long getExtStorageReserved()
    {
        return extStorageReserved;
    }

    @Deprecated
    public void setExtStorageReserved(final long extStorageReserved)
    {
        this.extStorageReserved = extStorageReserved;
    }
}
