/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.statistics;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class VirtualAppResourcesDto. This dto holds the statistics for virtual appliance.
 */
@XmlRootElement(name = "vappResources")
@XmlType(propOrder = {"id", "idEnterprise", "idVirtualDataCenter", "vappName", "vdcName",
"vmActive", "vmCreated", "volAttached"})
public class VirtualAppResourcesDto extends SingleResourceTransportDto
{

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -1466965412295692043L;

    private static final String TYPE = "application/vnd.abiquo.virtualappresources";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    /** The Constant MEDIA_TYPE_23. */
    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    /** The Constant MEDIA_TYPE_22. */
    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    /** The id. */
    private Integer id;

    /** The vdc name. */
    private String vdcName;

    /** The virtual appliance name. */
    private String vappName;

    /** The vol attached. */
    private int volAttached;

    /** The number of virtual machines created. */
    private int vmCreated;

    /** The virtual machine currently active in this virtual appliance. */
    private int vmActive;

    /** The id enterprise. */
    private int idEnterprise;

    /** The id virtual data center. */
    private int idVirtualDataCenter;

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Identifier of the virtual machine template definition.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * The id enterprise.
     * 
     * @output
     * @return the id enterprise
     */
    public int getIdEnterprise()
    {
        return idEnterprise;
    }

    /**
     * The id virtual data center.
     * 
     * @output
     * @return the id virtual data center
     */
    public int getIdVirtualDataCenter()
    {
        return idVirtualDataCenter;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Name for this virtual appliance.
     * 
     * @output
     * @return the vapp name
     */
    public String getVappName()
    {
        return vappName;
    }

    /**
     * Name for the virtualdatacenter.
     * 
     * @output
     * @return the vdc name
     */
    public String getVdcName()
    {
        return vdcName;
    }

    /**
     * Number of virtual machines currently running in this virtual appliance.
     * 
     * @output
     * @return the virtual machine active
     */
    public int getVmActive()
    {
        return vmActive;
    }

    /**
     * Number of virtual machines created in this virtual appliance.
     * 
     * @output
     * @return the virtual machines created
     */
    public int getVmCreated()
    {
        return vmCreated;
    }

    /**
     * Number of volumes currently attached to a virtual machine in this virtual appliance.
     * 
     * @output
     * @return the volume attached
     */
    public int getVolAttached()
    {
        return volAttached;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Sets the id enterprise.
     * 
     * @param idEnterprise the new id enterprise
     */
    public void setIdEnterprise(final int idEnterprise)
    {
        this.idEnterprise = idEnterprise;
    }

    /**
     * Sets the id virtual data center.
     * 
     * @param idVirtualDataCenter the new id virtual data center
     */
    public void setIdVirtualDataCenter(final int idVirtualDataCenter)
    {
        this.idVirtualDataCenter = idVirtualDataCenter;
    }

    /**
     * Sets the vapp name.
     * 
     * @param vappName the new vapp name
     */
    public void setVappName(final String vappName)
    {
        this.vappName = vappName;
    }

    /**
     * Sets the vdc name.
     * 
     * @param vdcName the new vdc name
     */
    public void setVdcName(final String vdcName)
    {
        this.vdcName = vdcName;
    }

    /**
     * Sets the virtual machine active.
     * 
     * @param vmActive the new virtual machine active
     */
    public void setVmActive(final int vmActive)
    {
        this.vmActive = vmActive;
    }

    /**
     * Sets the virtual machine created.
     * 
     * @param vmCreated the new virtual machine created
     */
    public void setVmCreated(final int vmCreated)
    {
        this.vmCreated = vmCreated;
    }

    /**
     * Sets the volume attached.
     * 
     * @param volAttached the new volume attached
     */
    public void setVolAttached(final int volAttached)
    {
        this.volAttached = volAttached;
    }

}
