/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.statistics;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

/**
 * The Class VirtualDatacenterResourcesDto. This representation holds the statistics for virtual
 * datacenter.
 */
@XmlRootElement(name = "vdcResources")
@XmlType(propOrder = {"id", "extStorageReservedInMb", "extStorageReserved", "extStorageUsedInMb",
"extStorageUsed", "idEnterprise", "localStorageReservedInMb", "localStorageReserved",
"localStorageUsedInMb", "localStorageUsed", "memoryReservedInMb", "memoryReserved",
"memoryUsedInMb", "memoryUsed", "publicIPsReserved", "publicIPsUsed", "vdcName",
"virtualCpuReserved", "virtualCpuUsed", "vlanReserved", "vlanUsed", "vmActive", "vmCreated",
"volAttached", "volCreated"})
public class VirtualDatacenterResourcesDto extends SingleResourceTransportDto
{
    private static final long serialVersionUID = 5990721643175198188L;

    private static final String TYPE = "application/vnd.abiquo.virtualdatacenterresources";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_23 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_23;

    public static final String MEDIA_TYPE_22 = TYPE + "+" + XML + VERSION_PARAM + API_VERSION_22;

    /** The id. */
    private Integer id;

    /** The memory reserved. */
    private long memoryReservedInMb;

    /** The vdc name. */
    private String vdcName;

    /** The vol created. */
    private int volCreated;

    /** The vlan reserved. */
    private long vlanReserved;

    /** The public i ps used. */
    private long publicIPsUsed;

    /** The public i ps reserved. */
    private long publicIPsReserved;

    /** The local storage reserved. */
    private long localStorageReservedInMb;

    /** The ext storage used. */
    private long extStorageUsedInMb;

    /** The vol attached. */
    private int volAttached;

    /** The vlan used. */
    private long vlanUsed;

    /** The ext storage reserved. */
    private long extStorageReservedInMb;

    /** The local storage used. */
    private long localStorageUsedInMb;

    /** The virtual cpu used. */
    private long virtualCpuUsed;

    /** Maximum number of Virtual CPUs reserved for this enterprise in this virtual datacenter. */
    private long virtualCpuReserved;

    /** The vm created. */
    private int vmCreated;

    /** The vm active. */
    private int vmActive;

    /** The memory used. */
    private long memoryUsedInMb;

    /** The id enterprise. */
    private int idEnterprise;

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getBaseMediaType()
     */
    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    /**
     * Maximum external storage size reserved for this enterprise in this virtual datacenter in
     * Megabytes.
     * 
     * @output
     * @return the ext storage reserved
     */
    public long getExtStorageReservedInMb()
    {
        return extStorageReservedInMb;
    }

    /**
     * External storage used (attached or mounted) by any virtual machines (in Megabytes).
     * 
     * @output
     * @return the ext storage used
     */
    public long getExtStorageUsedInMb()
    {
        return extStorageUsedInMb;
    }

    /**
     * Identifier of the virtual machine template definition.
     * 
     * @output
     * @return the id
     */
    public Integer getId()
    {
        return id;
    }

    /**
     * The id enterprise.
     * 
     * @output
     * @return the id enterprise
     */
    public int getIdEnterprise()
    {
        return idEnterprise;
    }

    /**
     * Maximum storage size reserved for this enterprise in this virtual datacenter for Virtual
     * Machines in Megabytes.
     * 
     * @output
     * @return the local storage reserved
     */
    public long getLocalStorageReservedInMb()
    {
        return localStorageReservedInMb;
    }

    /**
     * Total storage size used by Virtual Machines currently in a running state in Megabytes.
     * 
     * @output
     * @return the local storage used
     */
    public long getLocalStorageUsedInMb()
    {
        return localStorageUsedInMb;
    }

    /*
     * (non-Javadoc)
     * @see com.abiquo.model.transport.SingleResourceTransportDto#getMediaType()
     */
    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

    /**
     * Maximum amount of RAM reserved for this enterprise in this virtual datacenter in Megabytes.
     * 
     * @output
     * @return the memory reserved
     */
    public long getMemoryReservedInMb()
    {
        return memoryReservedInMb;
    }

    /**
     * Total amount of RAM used by Virtual Machines currently in a running state in Megabytes.
     * 
     * @output
     * @return the memory used
     */
    public long getMemoryUsedInMb()
    {
        return memoryUsedInMb;
    }

    /**
     * Total number of IPs assigned to this virtualDatacenter (Reserved).
     * 
     * @output
     * @return the public i ps reserved
     */
    public long getPublicIPsReserved()
    {
        return publicIPsReserved;
    }

    /**
     * Total number of IPs used by virtual machines.
     * 
     * @output
     * @return the public i ps used
     */
    public long getPublicIPsUsed()
    {
        return publicIPsUsed;
    }

    /**
     * virtual datacenter's name.
     * 
     * @output
     * @return the vdc name
     */
    public String getVdcName()
    {
        return vdcName;
    }

    /**
     * The virtual cpu reserved.
     * 
     * @output
     * @return the virtual cpu reserved
     */
    public long getVirtualCpuReserved()
    {
        return virtualCpuReserved;
    }

    /**
     * Total number of Virtual CPUs in Virtual Machines currently in a running state.
     * 
     * @output
     * @return the virtual cpu used
     */
    public long getVirtualCpuUsed()
    {
        return virtualCpuUsed;
    }

    /**
     * Total maximum number of VLANs reserved for this enterprise in this virtual datacenter.
     * (enterprise.vlanHard)
     * 
     * @output
     * @return the vlan reserved
     */
    public long getVlanReserved()
    {
        return vlanReserved;
    }

    /**
     * Total number of VLANs in use by this virtual datacenter.
     * 
     * @output
     * @return the vlan used
     */
    public long getVlanUsed()
    {
        return vlanUsed;
    }

    /**
     * Number of virtual machines currently running in this virtual datacenter.
     * 
     * @output
     * @return the vm active
     */
    public int getVmActive()
    {
        return vmActive;
    }

    /**
     * Number of virtual machines created in this virtual datacenter.
     * 
     * @output
     * @return the vm created
     */
    public int getVmCreated()
    {
        return vmCreated;
    }

    /**
     * Number of volumes currently attached to a virtual machine in this virtual datacenter.
     * 
     * @output
     * @return the vol attached
     */
    public int getVolAttached()
    {
        return volAttached;
    }

    /**
     * Number of volumes created in this virtual datacenter.
     * 
     * @output
     * @return the vol created
     */
    public int getVolCreated()
    {
        return volCreated;
    }

    /**
     * Sets the ext storage reserved.
     * 
     * @param extStorageReservedInMb the new ext storage reserved
     */
    public void setExtStorageReservedInMb(final long extStorageReservedInMb)
    {
        this.extStorageReservedInMb = extStorageReservedInMb;
    }

    /**
     * Sets the ext storage used.
     * 
     * @param extStorageUsedInMb the new ext storage used
     */
    public void setExtStorageUsedInMb(final long extStorageUsedInMb)
    {
        this.extStorageUsedInMb = extStorageUsedInMb;
    }

    /**
     * Sets the id.
     * 
     * @param id the new id
     */
    public void setId(final Integer id)
    {
        this.id = id;
    }

    /**
     * Sets the id enterprise.
     * 
     * @param idEnterprise the new id enterprise
     */
    public void setIdEnterprise(final int idEnterprise)
    {
        this.idEnterprise = idEnterprise;
    }

    /**
     * Sets the local storage reserved.
     * 
     * @param localStorageReservedInMb the new local storage reserved
     */
    public void setLocalStorageReservedInMb(final long localStorageReservedInMb)
    {
        this.localStorageReservedInMb = localStorageReservedInMb;
    }

    /**
     * Sets the local storage used.
     * 
     * @param localStorageUsedInMb the new local storage used
     */
    public void setLocalStorageUsedInMb(final long localStorageUsedInMb)
    {
        this.localStorageUsedInMb = localStorageUsedInMb;
    }

    /**
     * Sets the memory reserved.
     * 
     * @param memoryReservedInMb the new memory reserved
     */
    public void setMemoryReservedInMb(final long memoryReservedInMb)
    {
        this.memoryReservedInMb = memoryReservedInMb;
    }

    /**
     * Sets the memory used.
     * 
     * @param memoryUsedInMb the new memory used
     */
    public void setMemoryUsedInMb(final long memoryUsedInMb)
    {
        this.memoryUsedInMb = memoryUsedInMb;
    }

    /**
     * Sets the public i ps reserved.
     * 
     * @param publicIPsReserved the new public i ps reserved
     */
    public void setPublicIPsReserved(final long publicIPsReserved)
    {
        this.publicIPsReserved = publicIPsReserved;
    }

    /**
     * Sets the public i ps used.
     * 
     * @param publicIPsUsed the new public i ps used
     */
    public void setPublicIPsUsed(final long publicIPsUsed)
    {
        this.publicIPsUsed = publicIPsUsed;
    }

    /**
     * Sets the vdc name.
     * 
     * @param vdcName the new vdc name
     */
    public void setVdcName(final String vdcName)
    {
        this.vdcName = vdcName;
    }

    /**
     * Sets the virtual cpu reserved.
     * 
     * @param virtualCpuReserved the new virtual cpu reserved
     */
    public void setVirtualCpuReserved(final long virtualCpuReserved)
    {
        this.virtualCpuReserved = virtualCpuReserved;
    }

    /**
     * Sets the virtual cpu used.
     * 
     * @param virtualCpuUsed the new virtual cpu used
     */
    public void setVirtualCpuUsed(final long virtualCpuUsed)
    {
        this.virtualCpuUsed = virtualCpuUsed;
    }

    /**
     * Sets the vlan reserved.
     * 
     * @param vlanReserved the new vlan reserved
     */
    public void setVlanReserved(final long vlanReserved)
    {
        this.vlanReserved = vlanReserved;
    }

    /**
     * Sets the vlan used.
     * 
     * @param vlanUsed the new vlan used
     */
    public void setVlanUsed(final long vlanUsed)
    {
        this.vlanUsed = vlanUsed;
    }

    /**
     * Sets the vm active.
     * 
     * @param vmActive the new vm active
     */
    public void setVmActive(final int vmActive)
    {
        this.vmActive = vmActive;
    }

    /**
     * Sets the vm created.
     * 
     * @param vmCreated the new vm created
     */
    public void setVmCreated(final int vmCreated)
    {
        this.vmCreated = vmCreated;
    }

    /**
     * Sets the vol attached.
     * 
     * @param volAttached the new vol attached
     */
    public void setVolAttached(final int volAttached)
    {
        this.volAttached = volAttached;
    }

    /**
     * Sets the vol created.
     * 
     * @param volCreated the new vol created
     */
    public void setVolCreated(final int volCreated)
    {
        this.volCreated = volCreated;
    }

    @Deprecated
    private long memoryUsed;

    @Deprecated
    private long memoryReserved;

    @Deprecated
    private long localStorageUsed;

    @Deprecated
    private long localStorageReserved;

    @Deprecated
    private long extStorageUsed;

    @Deprecated
    private long extStorageReserved;

    @Deprecated
    public long getMemoryUsed()
    {
        return memoryUsed;
    }

    @Deprecated
    public void setMemoryUsed(final long memoryUsed)
    {
        this.memoryUsed = memoryUsed;
    }

    @Deprecated
    public long getMemoryReserved()
    {
        return memoryReserved;
    }

    @Deprecated
    public void setMemoryReserved(final long memoryReserved)
    {
        this.memoryReserved = memoryReserved;
    }

    @Deprecated
    public long getLocalStorageUsed()
    {
        return localStorageUsed;
    }

    @Deprecated
    public void setLocalStorageUsed(final long localStorageUsed)
    {
        this.localStorageUsed = localStorageUsed;
    }

    @Deprecated
    public long getLocalStorageReserved()
    {
        return localStorageReserved;
    }

    @Deprecated
    public void setLocalStorageReserved(final long localStorageReserved)
    {
        this.localStorageReserved = localStorageReserved;
    }

    @Deprecated
    public long getExtStorageUsed()
    {
        return extStorageUsed;
    }

    @Deprecated
    public void setExtStorageUsed(final long extStorageUsed)
    {
        this.extStorageUsed = extStorageUsed;
    }

    @Deprecated
    public long getExtStorageReserved()
    {
        return extStorageReserved;
    }

    @Deprecated
    public void setExtStorageReserved(final long extStorageReserved)
    {
        this.extStorageReserved = extStorageReserved;
    }
}
