/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.task;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "job")
@XmlType(propOrder = {"id", "parentTaskId", "type", "description", "state", "rollbackState",
"creationTimestamp", "timestamp"})
public class JobDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.job";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = 3441968794948596375L;

    private String id;

    private String parentTaskId;

    private JobType type;

    private String description;

    private JobState state;

    private JobState rollbackState;

    private Long creationTimestamp;

    private Long timestamp;

    /**
     * Creation timestamp in standard UNIX timestamp
     * 
     * @output
     */
    @NotNull
    public Long getCreationTimestamp()
    {
        return creationTimestamp;
    }

    /**
     * Timestamp of the last update on the job in standard UNIX timestamp
     * 
     * @output
     */
    @NotNull
    public Long getTimestamp()
    {
        return timestamp;
    }

    /**
     * Identifier of the job
     * 
     * @output
     */
    @NotNull
    public String getId()
    {
        return id;
    }

    /**
     * Type of the job
     * 
     * @output
     */
    @NotNull
    public JobType getType()
    {
        return type;
    }

    /**
     * Current state of the job
     * 
     * @output
     */
    public JobState getState()
    {
        return state;
    }

    /**
     * Identifier of the parent task
     * 
     * @output
     */
    public String getParentTaskId()
    {
        return parentTaskId;
    }

    /**
     * Description of the job
     * 
     * @output
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Current rollback state of the job
     * 
     * @output
     */
    public JobState getRollbackState()
    {
        return rollbackState;
    }

    public void setCreationTimestamp(final Long creationTimestamp)
    {
        this.creationTimestamp = creationTimestamp;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public void setId(final String id)
    {
        this.id = id;
    }

    public void setParentTaskId(final String parentTaskId)
    {
        this.parentTaskId = parentTaskId;
    }

    public void setRollbackState(final JobState rollbackState)
    {
        this.rollbackState = rollbackState;
    }

    public void setState(final JobState state)
    {
        this.state = state;
    }

    public void setTimestamp(final Long timestamp)
    {
        this.timestamp = timestamp;
    }

    public void setType(final JobType type)
    {
        this.type = type;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
