/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.task;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "jobextended")
@XmlType(propOrder = {"progress", "errorCause"})
public class JobExtendedDto extends JobDto
{
    private static final String TYPE = "application/vnd.abiquo.jobextended";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = 4902190084295941044L;

    /**
     * Include the error description for a FAILED job
     * 
     * @output
     */
    private String errorCause;

    /**
     * Include the progress for a STARTED job
     * 
     * @output
     */
    private Integer progress;

    public JobExtendedDto()
    {
    }

    public JobExtendedDto(final JobDto job)
    {
        setId(job.getId());
        setParentTaskId(job.getParentTaskId());
        setType(job.getType());
        setDescription(job.getDescription());
        setState(job.getState());
        setRollbackState(job.getRollbackState());
        setTimestamp(job.getTimestamp());
    }

    public String getErrorCause()
    {
        return errorCause;
    }

    public Integer getProgress()
    {
        return progress;
    }

    public void setErrorCause(final String errorCause)
    {
        this.errorCause = errorCause;
    }

    public void setProgress(final Integer progress)
    {
        this.progress = progress;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }

}
