/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.task;

import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import com.abiquo.model.transport.SingleResourceTransportDto;

@XmlRootElement(name = "task")
@XmlType(propOrder = {"taskId", "userId", "type", "ownerId", "state", "creationTimestamp",
"timestamp", "jobs"})
public class TaskDto extends SingleResourceTransportDto
{
    private static final String TYPE = "application/vnd.abiquo.task";

    public static final String MEDIA_TYPE = TYPE + "+" + JSON;

    public static final String SHORT_MEDIA_TYPE_JSON = MEDIA_TYPE;

    public static final String SHORT_MEDIA_TYPE_XML = TYPE + "+" + XML;

    public static final String MEDIA_TYPE_XML = TYPE + "+" + XML + VERSION_PARAM + API_VERSION;

    public static final String MEDIA_TYPE_JSON = MEDIA_TYPE + VERSION_PARAM + API_VERSION;

    private static final long serialVersionUID = 3587883337292250623L;

    private String taskId;

    private String userId;

    private TaskType type;

    private String ownerId;

    private TaskState state;

    private Long creationTimestamp;

    private long timestamp;

    private JobsDto jobs;

    public TaskDto()
    {
    }

    /**
     * Creation timestamp in standard UNIX timestamp
     * 
     * @output
     */
    @NotNull
    public Long getCreationTimestamp()
    {
        return creationTimestamp;
    }

    /**
     * Jobs collection of the task
     * 
     * @output
     */
    public JobsDto getJobs()
    {
        return jobs;
    }

    /**
     * Identifier of the task owner
     * 
     * @output
     */
    @NotNull
    public String getOwnerId()
    {
        return ownerId;
    }

    /**
     * Current state of the task
     * 
     * @output
     */
    @NotNull
    public TaskState getState()
    {
        return state;
    }

    /**
     * Identifier of the task
     * 
     * @output
     */
    @NotNull
    public String getTaskId()
    {
        return taskId;
    }

    /**
     * Timestamp of the last update on the task in standard UNIX timestamp
     * 
     * @output
     */
    @NotNull
    public long getTimestamp()
    {
        return timestamp;
    }

    /**
     * Type of the task
     * 
     * @output
     */
    @NotNull
    public TaskType getType()
    {
        return type;
    }

    /**
     * Identifier of the user who created the task
     * 
     * @output
     */
    public String getUserId()
    {
        return userId;
    }

    public void setCreationTimestamp(final Long creationTimestamp)
    {
        this.creationTimestamp = creationTimestamp;
    }

    public void setJobs(final JobsDto jobs)
    {
        this.jobs = jobs;
    }

    public void setOwnerId(final String ownerId)
    {
        this.ownerId = ownerId;
    }

    public void setState(final TaskState state)
    {
        this.state = state;
    }

    public void setTaskId(final String taskId)
    {
        this.taskId = taskId;
    }

    public void setTimestamp(final long timestamp)
    {
        this.timestamp = timestamp;
    }

    public void setType(final TaskType type)
    {
        this.type = type;
    }

    public void setUserId(final String userId)
    {
        this.userId = userId;
    }

    @Override
    public String getBaseMediaType()
    {
        return MEDIA_TYPE;
    }

    @Override
    public String getMediaType()
    {
        return MEDIA_TYPE_JSON;
    }
}
