/**
 * Licensed to Abiquo Holdings S.L. (Abiquo) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.abiquo.server.core.task;

import static com.abiquo.server.core.task.TaskOwnerType.CONVERSION;
import static com.abiquo.server.core.task.TaskOwnerType.VIRTUAL_MACHINE;
import static com.abiquo.server.core.task.TaskOwnerType.VIRTUAL_MACHINE_TEMPLATE;
import static com.abiquo.server.core.task.TaskOwnerType.REPOSITORY;

public enum TaskType
{
    // Tarantino
    DEPLOY(VIRTUAL_MACHINE),

    UNDEPLOY(VIRTUAL_MACHINE),

    RECONFIGURE(VIRTUAL_MACHINE),

    POWER_ON(VIRTUAL_MACHINE),

    POWER_OFF(VIRTUAL_MACHINE),

    PAUSE(VIRTUAL_MACHINE),

    RESUME(VIRTUAL_MACHINE),

    RESET(VIRTUAL_MACHINE),

    INSTANCE(VIRTUAL_MACHINE),

    HA_DEPLOY(VIRTUAL_MACHINE),

    HA_UNDEPLOY(VIRTUAL_MACHINE),

    REFRESH(VIRTUAL_MACHINE),

    // Conversion Manager
    MAKE_PERSISTENT(VIRTUAL_MACHINE_TEMPLATE),

    CONVERT_DISK(CONVERSION),

    CONVERT_DISK_FROM_INSTANCE(VIRTUAL_MACHINE_TEMPLATE),

    // Virtual Machine Template
    DOWNLOAD(VIRTUAL_MACHINE_TEMPLATE),

    REFRESH_REPOSITORY(REPOSITORY);

    protected TaskOwnerType ownerType;

    private TaskType(final TaskOwnerType ownerType)
    {
        this.ownerType = ownerType;
    }

    public TaskOwnerType getOwnerType()
    {
        return ownerType;
    }
}
