/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.adapter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetadataJsonAdapter
extends JsonDeserializer<Map<String, Object>> {
    private static final String NULL = "null";

    public Map<String, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        return this.unmarshal(node.fields(), new HashMap<String, Object>());
    }

    public Map<String, Object> unmarshal(Iterator<Map.Entry<String, JsonNode>> nodes, Map<String, Object> map) {
        while (nodes.hasNext()) {
            Map.Entry<String, JsonNode> entry = nodes.next();
            if (entry.getValue().isValueNode()) {
                if (entry.getValue().asText() == null || NULL.equals(entry.getValue().asText()) || "".equals(entry.getValue().asText())) {
                    map.put(entry.getKey(), null);
                    continue;
                }
                map.put(entry.getKey(), entry.getValue().asText());
                continue;
            }
            if (entry.getValue().isObject()) {
                map.put(entry.getKey(), this.unmarshal(entry.getValue().fields(), new HashMap<String, Object>()));
                continue;
            }
            if (!entry.getValue().isArray()) continue;
            map.put(entry.getKey(), this.toList((ArrayNode)entry.getValue()));
        }
        return map;
    }

    private List<Object> toList(ArrayNode nodes) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int size = nodes.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                JsonNode node = nodes.get(i);
                if (node.isValueNode()) {
                    elements.add(node.asText());
                    continue;
                }
                if (node.isNull()) {
                    elements.add(NULL);
                    continue;
                }
                elements.add(this.unmarshal(node.fields(), new HashMap<String, Object>()));
            }
        }
        return elements;
    }
}

