/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.adapter;

import com.abiquo.model.util.StringSplitter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginOperationsXmlAdapter
extends XmlAdapter<Element, Map<String, Map<String, List<String>>>> {
    private DocumentBuilder documentBuilder;

    protected String getRootElementName() {
        return "operations";
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        if (null == this.documentBuilder) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.documentBuilder = dbf.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    public Element marshal(Map<String, Map<String, List<String>>> map) throws Exception {
        DocumentBuilder db = this.getDocumentBuilder();
        Document document = db.newDocument();
        Element rootElement = document.createElement(this.getRootElementName());
        this.marshalMap(map, rootElement, document);
        document.appendChild(rootElement);
        return rootElement;
    }

    private Element marshalMap(Map<String, Map<String, List<String>>> map, Element rootElement, Document document) {
        for (Map.Entry<String, Map<String, List<String>>> outer : map.entrySet()) {
            Element element = document.createElement(outer.getKey().toLowerCase());
            for (Map.Entry<String, List<String>> inner : outer.getValue().entrySet()) {
                Element innerElement = document.createElement(inner.getKey());
                StringBuilder content = new StringBuilder("");
                List<String> value = inner.getValue();
                if (value != null) {
                    content.append(this.join(value));
                }
                innerElement.setTextContent(content.toString());
                element.appendChild(innerElement);
            }
            rootElement.appendChild(element);
        }
        return rootElement;
    }

    private String join(List<String> value) {
        Objects.requireNonNull(value, "values is null");
        Iterator<String> parts = value.iterator();
        StringBuilder join = new StringBuilder("");
        if (parts.hasNext()) {
            join.append(parts.next());
            while (parts.hasNext()) {
                join.append(",");
                join.append(parts.next());
            }
        }
        return join.toString();
    }

    public Map<String, Map<String, List<String>>> unmarshal(Element element) throws Exception {
        if (null == element) {
            return null;
        }
        return this.unmarshalMap(element.getFirstChild(), new HashMap<String, Map<String, List<String>>>());
    }

    private Map<String, Map<String, List<String>>> unmarshalMap(Node node, Map<String, Map<String, List<String>>> map) {
        if (node.getNodeType() == 1 && node.getFirstChild() == null) {
            map.put(node.getNodeName(), null);
        } else if (node.getNodeType() == 1) {
            Map<String, List<String>> inner = this.extractInner(node.getFirstChild());
            map.put(node.getNodeName(), inner);
        }
        if (node.getNextSibling() != null) {
            this.unmarshalMap(node.getNextSibling(), map);
        }
        return map;
    }

    private Map<String, List<String>> extractInner(Node node) {
        if (node.getFirstChild() != null) {
            this.extractInner(node.getFirstChild());
        }
        HashMap<String, List<String>> inner = new HashMap<String, List<String>>();
        if (node.getFirstChild().getNodeType() == 3) {
            inner.put(node.getNodeName(), StringSplitter.commaSplit(node.getFirstChild().getNodeValue()));
        }
        return inner;
    }
}

