/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.enumerator;

public enum MachineState {
    STOPPED,
    PROVISIONED,
    NOT_MANAGED,
    MANAGED,
    HALTED,
    UNLICENSED,
    HA_IN_PROGRESS,
    DISABLED_FOR_HA,
    HALTED_FOR_SAVE;


    public boolean isRetrieveAllowed() {
        if (this.isBeingProcessedByHA()) {
            return false;
        }
        switch (this) {
            case MANAGED: 
            case HALTED: {
                return true;
            }
        }
        return false;
    }

    public boolean isBeingProcessedByHA() {
        switch (this) {
            case HA_IN_PROGRESS: 
            case DISABLED_FOR_HA: {
                return true;
            }
        }
        return false;
    }
}

