/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.enumerator;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum OSType {
    OTHER(1, "Other", false),
    MACOS(2, "MACOS", false),
    SOLARIS(29, "Solaris", false),
    LINUX(36, "LINUX", false),
    FREEBSD(42, "FreeBSD", false),
    NETBSD(43, "NetBSD", false),
    OPENBSD(65, "OpenBSD", false),
    NOT_APPLICABLE(66, "Not Applicable", false),
    WINDOWS(67, "Windows", true),
    WINDOWS_SERVER_2003(69, "Microsoft Windows Server 2003", false),
    WINDOWS_SERVER_2003_64(70, "Microsoft Windows Server 2003 64-Bit", true),
    WINDOWS_SERVER_2008(76, "Microsoft Windows Server 2008", false),
    WINDOWS_SERVER_2008_64(77, "Microsoft Windows Server 2008 64-Bit", true),
    FREEBSD_64(78, "FreeBSD 64-Bit", true),
    RHEL(79, "RedHat Enterprise Linux", false),
    RHEL_64(80, "RedHat Enterprise Linux 64-Bit", true),
    SOLARIS_64(81, "Solaris 64-Bit", true),
    SUSE(82, "SUSE", false),
    SUSE_64(83, "SUSE 64-Bit", true),
    SLES(84, "SLES", false),
    SLES_64(85, "SLES 64-Bit", true),
    NOVELL_OES(86, "Novell OES", true),
    MANDRIVA(89, "Mandriva", false),
    MANDRIVA_64(90, "Mandriva 64-Bit", true),
    TURBOLINUX(91, "TurboLinux", false),
    TURBOLINUX_64(92, "TurboLinux 64-Bit", true),
    UBUNTU(93, "Ubuntu", false),
    UBUNTU_64(94, "Ubuntu 64-Bit", true),
    DEBIAN(95, "Debian", false),
    DEBIAN_64(96, "Debian 64-Bit", false),
    LINUX_2_4(97, "Linux 2.4.x", false),
    LINUX_2_4_64(98, "Linux 2.4.x 64-Bit", true),
    LINUX_2_6(99, "Linux 2.6.x", false),
    LINUX_2_6_64(100, "Linux 2.6.x 64-Bit", true),
    LINUX_64(101, "Linux 64-Bit", true),
    OTHER_64(102, "Other 64-Bit", true),
    WINDOWS_SERVER_2008_R2(103, "Microsoft Windows Server 2008 R2", true),
    ESXI(104, "VMware ESXi", true),
    WINDOWS_7(105, "Microsoft Windows 7", false),
    CENTOS(106, "CentOS 32-bit", false),
    CENTOS_64(107, "CentOS 64-bit", true),
    ORACLE_ENTERPRISE_LINUX(108, "Oracle Enterprise Linux 32-bit", false),
    ORACLE_ENTERPRISE_LINUX_64(109, "Oracle Enterprise Linux 64-bit", true),
    ECOMSTATION_32(110, "eComStation 32-bit", false),
    WINDOWS_SERVER_2011(111, "Microsoft Windows Server 2011", true),
    WINDOWS_SERVER_2012(113, "Microsoft Windows Server 2012", true),
    WINDOWS_8(114, "Microsoft 8", false),
    WINDOWS_8_64(115, "Microsoft 8 64-bit", true),
    WINDOWS_SERVER_2012_R2(116, "Microsoft Windows Server 2012 R2", true),
    WINDOWS_SERVER_2016(117, "Microsoft Windows Server 2016", true),
    WINDOWS_81(118, "Microsoft Windows 8.1", false),
    WINDOWS_81_64(119, "Microsoft Windows 8.1 64-bit", true),
    WINDOWS_10(120, "Microsoft Windows 10", false),
    WINDOWS_10_64(121, "Microsoft Windows 10 64-bit", true),
    UNRECOGNIZED(Integer.MAX_VALUE, "UNRECOGNIZED", true);

    public static final List<OSType> arch64;
    public static final List<OSType> arch32;
    final int code;
    final String description;
    final boolean is64b;

    public static List<OSType> computeArch(boolean arch64) {
        LinkedList<OSType> filtered = new LinkedList<OSType>();
        for (OSType value : OSType.values()) {
            if (arch64 != value.is64Bit()) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private OSType(int code, String description, boolean is64b) {
        this.code = code;
        this.description = description;
        this.is64b = is64b;
    }

    public static OSType fromCode(int code) {
        for (OSType value : OSType.values()) {
            if (code != value.getCode()) continue;
            return value;
        }
        return UNRECOGNIZED;
    }

    public static OSType fromValue(String name) {
        for (OSType value : OSType.values()) {
            if (!name.equalsIgnoreCase(value.name())) continue;
            return value;
        }
        return UNRECOGNIZED;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean is64Bit() {
        return this.is64b;
    }

    static {
        arch64 = OSType.computeArch(true);
        arch32 = OSType.computeArch(false);
    }
}

