/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.enumerator;

import java.util.Arrays;
import java.util.List;

public enum RemoteServiceType {
    VIRTUAL_FACTORY("Virtualization Manager", "virtualfactory", "http://", 80, true),
    VIRTUAL_SYSTEM_MONITOR("Monitor Manager", "vsm", "http://", 80, true),
    NARS("Plugin Manager", "nars", "http://", 80, true),
    DHCP_SERVICE("DHCP Service", "dhcp", "omapi://", 7911, true),
    BPM_SERVICE("Business Process Manager", "bpm-async", "http://", 80, false),
    APPLIANCE_MANAGER("Appliance Manager", "am", "http://", 80, false),
    DHCPv6("DHCPv6", "dhcpv6", "omapi://", 7911, true),
    REMOTE_ACCESS("Remote Access Manager", "guacd", "guacd://", 4822, true);

    private String name;
    private String serviceMapping;
    private String defaultProtocol;
    private Integer defaultPort;
    private boolean reusable;
    public static final List<RemoteServiceType> datacenterAllowedValues;
    public static final List<RemoteServiceType> publicCloudRegionAllowedValues;

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceMapping() {
        return this.serviceMapping;
    }

    public String getRestIdentifier() {
        return this.name().replaceAll("_", "");
    }

    public boolean isReusable() {
        return this.reusable;
    }

    private RemoteServiceType(String name, String serviceMapping, String defaultProtocol, Integer defaultPort, boolean isReusable) {
        this.name = name;
        this.serviceMapping = serviceMapping;
        this.defaultProtocol = defaultProtocol;
        this.defaultPort = defaultPort;
        this.reusable = isReusable;
    }

    public boolean canBeChecked() {
        return this != DHCP_SERVICE && this != DHCPv6 && this != REMOTE_ACCESS;
    }

    public boolean checkUniqueness() {
        return this == APPLIANCE_MANAGER || this == BPM_SERVICE || this == VIRTUAL_FACTORY || this == VIRTUAL_SYSTEM_MONITOR || this == NARS;
    }

    public boolean isAllowedForDatacenter() {
        return datacenterAllowedValues.contains((Object)this);
    }

    public boolean isAllowedForPublicCloudRegion() {
        return publicCloudRegionAllowedValues.contains((Object)this);
    }

    public static RemoteServiceType valueFromName(String name) {
        for (RemoteServiceType element : RemoteServiceType.values()) {
            if (!name.replaceAll("_", "").equalsIgnoreCase(element.getRestIdentifier())) continue;
            return element;
        }
        return RemoteServiceType.valueOf(name);
    }

    static {
        datacenterAllowedValues = Arrays.asList(VIRTUAL_FACTORY, VIRTUAL_SYSTEM_MONITOR, NARS, DHCP_SERVICE, BPM_SERVICE, APPLIANCE_MANAGER, DHCPv6, REMOTE_ACCESS);
        publicCloudRegionAllowedValues = Arrays.asList(VIRTUAL_FACTORY, VIRTUAL_SYSTEM_MONITOR, NARS, REMOTE_ACCESS);
    }
}

