/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.transport;

import com.abiquo.model.rest.RESTLink;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public abstract class ResourceLinksDto
implements Serializable {
    private static final long serialVersionUID = -5372113273136328383L;
    protected List<RESTLink> links = new ArrayList<RESTLink>();

    @XmlElement(name="link")
    @JsonProperty(value="links")
    public List<RESTLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<RESTLink> links) {
        this.links = links;
    }

    public void addLink(RESTLink link) {
        if (this.links == null) {
            this.links = new ArrayList<RESTLink>();
        }
        this.links.add(link);
    }

    public void addLinks(List<RESTLink> links) {
        if (this.links == null) {
            this.links = new ArrayList<RESTLink>();
        }
        this.links.addAll(links);
    }

    public RESTLink searchLink(String rel) {
        for (RESTLink link : this.getLinks()) {
            if (rel == null || !rel.equals(link.getRel()) || link.getHref() == null) continue;
            return link;
        }
        return null;
    }

    public List<RESTLink> searchLinks(String rel) {
        ArrayList<RESTLink> links = new ArrayList<RESTLink>();
        if (rel == null) {
            return links;
        }
        for (RESTLink link : this.getLinks()) {
            if (!rel.equals(link.getRel())) continue;
            links.add(link);
        }
        return links;
    }

    public RESTLink searchLink(String rel, String title) {
        if (this.getLinks() == null) {
            this.setLinks(new ArrayList<RESTLink>());
        }
        for (RESTLink link : this.getLinks()) {
            if (!link.getRel().equals(rel) || !link.getTitle().equals(title)) continue;
            return link;
        }
        return null;
    }

    public List<RESTLink> searchLinksByHref(String href) {
        if (this.getLinks() == null) {
            this.setLinks(new ArrayList<RESTLink>());
        }
        ArrayList<RESTLink> links = new ArrayList<RESTLink>();
        for (RESTLink link : this.getLinks()) {
            if (!this.sameHref(link.getHref(), href)) continue;
            links.add(link);
        }
        return links;
    }

    private boolean sameHref(String one, String other) {
        try {
            URI first = new URI(one);
            URI second = new URI(other);
            HashSet<String> firstQueryParams = new HashSet<String>();
            String firstQueryStr = this.nullToEmpty(first.getQuery());
            firstQueryParams.addAll(Arrays.asList(firstQueryStr.split("&")));
            HashSet<String> secondQueryParams = new HashSet<String>();
            String secondQuerStr = this.nullToEmpty(second.getQuery());
            secondQueryParams.addAll(Arrays.asList(secondQuerStr.split("&")));
            return this.nullToEmpty(first.getScheme()).equals(this.nullToEmpty(second.getScheme())) && this.nullToEmpty(first.getHost()).equals(this.nullToEmpty(second.getHost())) && this.nullToEmpty(first.getPath()).equals(this.nullToEmpty(second.getPath())) && firstQueryParams.size() == secondQueryParams.size() && firstQueryParams.containsAll(secondQueryParams);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    public void modifyLink(String rel, String href) {
        RESTLink link = this.searchLink(rel);
        if (link == null) {
            this.addLink(new RESTLink(rel, href));
        } else {
            link.setHref(href);
        }
    }

    public Integer getIdFromLink(String rel) {
        RESTLink restLink = this.searchLink(rel);
        if (restLink == null) {
            return null;
        }
        return restLink.getId();
    }

    @XmlTransient
    @JsonIgnore
    public Integer getEntityId() {
        Integer id = this.getIdFromLink("edit");
        if (id == null) {
            id = this.getIdFromLink("self");
        }
        return id;
    }
}

