/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ModelTransformer {
    public static <T> T transportFromPersistence(Class<T> clazz, Object persistent) throws Exception {
        return ModelTransformer.transform(clazz, clazz, persistent);
    }

    public static <T> T persistenceFromTransport(Class<T> clazz, Object transport) throws Exception {
        return ModelTransformer.transform(transport.getClass(), clazz, transport);
    }

    public static <T> T transform(Class sourceClass, Class<T> targetClass, Object template) throws Exception {
        T instance = targetClass.newInstance();
        ModelTransformer.transform(sourceClass, targetClass, template, instance);
        return instance;
    }

    public static <T> void transform(Class sourceClass, Class<T> targetClass, Object source, T target) throws Exception {
        Object[] transportFields = sourceClass.getDeclaredFields();
        for (Class superClass = sourceClass.getSuperclass(); superClass != null && !superClass.getSimpleName().equalsIgnoreCase("SingleResourceTransportDto"); superClass = superClass.getSuperclass()) {
            transportFields = (Field[])ModelTransformer.addAll(transportFields, superClass.getDeclaredFields());
        }
        for (Object field : transportFields) {
            int modifiers = ((Field)field).getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
            String name = ((Field)field).getName();
            try {
                if ((!ModelTransformer.fieldExist(name, targetClass) || !ModelTransformer.fieldExist(name, source.getClass())) && (!ModelTransformer.getterExist(name, source.getClass()) || !ModelTransformer.setterExist(name, targetClass, ((Field)field).getType()))) continue;
                Object value = ModelTransformer.getter(name, source.getClass()).invoke(source, new Object[0]);
                if (!ModelTransformer.setterExist(name, targetClass, ((Field)field).getType())) continue;
                try {
                    ModelTransformer.setter(name, targetClass, ((Field)field).getType()).invoke(target, value);
                }
                catch (Exception ie) {
                    ModelTransformer.setter(name, targetClass, value.getClass()).invoke(target, value);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private static Method getter(String fieldName, Class clazz) throws Exception {
        try {
            return ModelTransformer.getter("get", fieldName, clazz);
        }
        catch (NoSuchMethodException ex) {
            return ModelTransformer.getter("is", fieldName, clazz);
        }
    }

    private static Method getter(String prefix, String fieldName, Class clazz) throws Exception {
        String name = prefix + ModelTransformer.capitalize(fieldName);
        return clazz.getMethod(name, new Class[0]);
    }

    private static Method setter(String fieldName, Class clazz, Class type) throws Exception {
        String name = "set" + ModelTransformer.capitalize(fieldName);
        Method method = clazz.getMethod(name, type);
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    private static boolean fieldExist(String fieldName, Class clazz) throws Exception {
        try {
            return clazz.getDeclaredField(fieldName) != null;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    private static boolean getterExist(String fieldName, Class clazz) throws Exception {
        try {
            return ModelTransformer.getter(fieldName, clazz) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private static boolean setterExist(String fieldName, Class clazz, Class type) throws Exception {
        try {
            return ModelTransformer.setter(fieldName, clazz, type) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            if (array2 == null) {
                return null;
            }
            return (Object[])array2.clone();
        }
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type1 = array1.getClass().getComponentType();
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
            }
            throw ase;
        }
        return joinedArray;
    }
}

