/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.model.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;

public class TimestampUtil {
    public static final ZoneId SYSTEM_TIMEZONE = ZoneId.of(TimeZone.getDefault().getID());
    public static final ZoneId UTC = ZoneId.of("UTC");

    public static Timestamp convertEpochMilliToUTCTimestamp(long epochmillis, String zoneIdOfEpochmillis) {
        return TimestampUtil.convertZonedTimestampToUTCTimestamp(new Timestamp(epochmillis), ZoneId.of(zoneIdOfEpochmillis));
    }

    public static Timestamp convertZonedTimestampToUTCTimestamp(Timestamp serverTimestamp, ZoneId zoneOfGivenTimestamp) {
        Instant instant = serverTimestamp.toInstant();
        ZonedDateTime serverZoned = ZonedDateTime.ofInstant(instant, zoneOfGivenTimestamp);
        ZonedDateTime UTCZoned = serverZoned.withZoneSameInstant(UTC);
        return Timestamp.valueOf(UTCZoned.toLocalDateTime());
    }
}

