/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.server.core.cloud;

import com.abiquo.model.adapter.MetadataJsonAdapter;
import com.abiquo.model.adapter.MetadataJsonSerializer;
import com.abiquo.model.adapter.MetadataXmlAdapter;
import com.abiquo.model.adapter.NoOpConverter;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.server.core.cloud.NatRuleDto;
import com.abiquo.server.core.cloud.VirtualMachineLightDto;
import com.abiquo.server.core.cloud.VirtualMachineType;
import com.abiquo.server.core.cloud.backup.BackupPolicyDefinitionDto;
import com.abiquo.server.core.cloud.chef.RunlistElementsDto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="virtualMachine")
@XmlType(propOrder={"id", "uuid", "fqdn", "description", "coresPerSocket", "idState", "idType", "type", "highDisponibility", "keymap", "runlist", "metadata", "monitored", "monitoringLevel", "protected", "protectedCause", "variables", "backupPolicies", "lastSynchronize", "generateGuestInitialPassword", "natRules", "internalProviderId", "vdrpEnabled", "vdrpPort", "vdrpIP", "password", "deallocated"})
public class VirtualMachineDto
extends VirtualMachineLightDto {
    private static final long serialVersionUID = -8877350185009627544L;
    private static final String TYPE = "application/vnd.abiquo.virtualmachine";
    public static final String MEDIA_TYPE = "application/vnd.abiquo.virtualmachine+json";
    public static final String SHORT_MEDIA_TYPE_JSON = "application/vnd.abiquo.virtualmachine+json";
    public static final String SHORT_MEDIA_TYPE_XML = "application/vnd.abiquo.virtualmachine+xml";
    public static final String MEDIA_TYPE_XML = "application/vnd.abiquo.virtualmachine+xml; version=5.0";
    public static final String MEDIA_TYPE_JSON = "application/vnd.abiquo.virtualmachine+json; version=5.0";
    private Integer id;
    private String uuid;
    private String description;
    private Integer coresPerSocket;
    private boolean deallocated;
    @Deprecated
    private int idState;
    @Deprecated
    private int highDisponibility;
    @Deprecated
    private int idType;
    private VirtualMachineType type;
    private String keymap;
    private RunlistElementsDto runlistElements;
    private Map<String, Object> metadata;
    private boolean monitored;
    private String monitoringLevel;
    @JsonIgnore
    private boolean isProtected;
    private String protectedCause;
    private Map<String, String> variables = new HashMap<String, String>();
    private List<BackupPolicyDefinitionDto> backupPolicies = new ArrayList<BackupPolicyDefinitionDto>();
    private Long lastSynchronize;
    private String fqdn;
    private boolean generateGuestInitialPassword;
    private List<NatRuleDto> natRules = new ArrayList<NatRuleDto>();
    private String internalProviderId;
    private Integer vdrpPort;
    private String vdrpIP;
    private Boolean vdrpEnabled;
    private String password;

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public int getHighDisponibility() {
        return this.highDisponibility;
    }

    public Integer getId() {
        return this.id;
    }

    @Deprecated
    public int getIdState() {
        return this.idState;
    }

    @Deprecated
    public int getIdType() {
        return this.idType;
    }

    public VirtualMachineType getType() {
        return this.type;
    }

    public String getKeymap() {
        return this.keymap;
    }

    public RunlistElementsDto getRunlist() {
        return this.runlistElements;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Long getLastSynchronize() {
        return this.lastSynchronize;
    }

    public boolean isGenerateGuestInitialPassword() {
        return this.generateGuestInitialPassword;
    }

    public void setCoresPerSocket(Integer coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public void setHighDisponibility(int highDisponibility) {
        this.highDisponibility = highDisponibility;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Deprecated
    public void setIdState(int idState) {
        this.idState = idState;
    }

    @Deprecated
    public void setIdType(int idType) {
        this.idType = idType;
    }

    public void setType(VirtualMachineType type) {
        this.type = type;
    }

    public void setKeymap(String keymap) {
        this.keymap = keymap;
    }

    public void setRunlist(RunlistElementsDto runlistElements) {
        this.runlistElements = runlistElements;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @XmlAnyElement
    @XmlJavaTypeAdapter(value=MetadataXmlAdapter.class)
    @JsonSerialize(using=MetadataJsonSerializer.class, converter=NoOpConverter.class)
    @JsonDeserialize(using=MetadataJsonAdapter.class, converter=NoOpConverter.class)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public String getMonitoringLevel() {
        return this.monitoringLevel;
    }

    public void setMonitoringLevel(String monitoringLevel) {
        this.monitoringLevel = monitoringLevel;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public String getProtectedCause() {
        return this.protectedCause;
    }

    public void setProtectedCause(String protectedCause) {
        this.protectedCause = protectedCause;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @XmlElement(name="backuppolicy")
    @JsonProperty(value="backuppolicies")
    public List<BackupPolicyDefinitionDto> getBackupPolicies() {
        return this.backupPolicies;
    }

    public void setBackupPolicies(List<BackupPolicyDefinitionDto> backupPolicies) {
        this.backupPolicies = backupPolicies;
    }

    public void setLastSynchronize(Long lastSynchronize) {
        this.lastSynchronize = lastSynchronize;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public void setGenerateGuestInitialPassword(boolean generateGuestInitialPassword) {
        this.generateGuestInitialPassword = generateGuestInitialPassword;
    }

    @XmlElement(name="natrule")
    @JsonProperty(value="natrules")
    public List<NatRuleDto> getNatRules() {
        return this.natRules;
    }

    public void setNatRules(List<NatRuleDto> natRules) {
        this.natRules = natRules;
    }

    public void setNicLinks(List<RESTLink> nics) {
        Iterator<RESTLink> currentNics = this.getLinks().iterator();
        while (currentNics.hasNext()) {
            if (!currentNics.next().getRel().toLowerCase().startsWith("nic")) continue;
            currentNics.remove();
        }
        for (RESTLink nicLink : nics) {
            if (!nicLink.getRel().toLowerCase().startsWith("nic")) continue;
            this.getLinks().add(nicLink);
        }
    }

    public Integer getVdrpPort() {
        return this.vdrpPort;
    }

    public void setVdrpPort(Integer vdrpPort) {
        this.vdrpPort = vdrpPort;
    }

    public String getVdrpIP() {
        return this.vdrpIP;
    }

    public void setVdrpIP(String vdrpIP) {
        this.vdrpIP = vdrpIP;
    }

    public Boolean getVdrpEnabled() {
        return this.vdrpEnabled;
    }

    public void setVdrpEnabled(Boolean vdrpEnabled) {
        this.vdrpEnabled = vdrpEnabled;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getBaseMediaType() {
        return "application/vnd.abiquo.virtualmachine+json";
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE_JSON;
    }

    public String getInternalProviderId() {
        return this.internalProviderId;
    }

    public void setInternalProviderId(String internalProviderId) {
        this.internalProviderId = internalProviderId;
    }

    public boolean isDeallocated() {
        return this.deallocated;
    }

    public void setDeallocated(boolean deallocated) {
        this.deallocated = deallocated;
    }
}

