/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.server.core.cloud;

import com.abiquo.server.core.cloud.VirtualMachineState;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum VirtualMachineStateTransition {
    CONFIGURE(Collections.singleton(VirtualMachineState.ALLOCATED), VirtualMachineState.CONFIGURED),
    RECONFIGURE(Collections.singleton(VirtualMachineState.OFF), VirtualMachineState.CONFIGURED),
    DECONFIGURE(Collections.singleton(VirtualMachineState.CONFIGURED), VirtualMachineState.ALLOCATED),
    POWERON(new HashSet<VirtualMachineState>(Arrays.asList(VirtualMachineState.CONFIGURED, VirtualMachineState.OFF)), VirtualMachineState.ON),
    POWEROFF(Collections.singleton(VirtualMachineState.ON), VirtualMachineState.OFF),
    SHUTDOWN(Collections.singleton(VirtualMachineState.ON), VirtualMachineState.OFF),
    RESET(Collections.singleton(VirtualMachineState.ON), VirtualMachineState.ON),
    PAUSE(Collections.singleton(VirtualMachineState.ON), VirtualMachineState.PAUSED),
    RESUME(Collections.singleton(VirtualMachineState.PAUSED), VirtualMachineState.ON),
    SNAPSHOT(Collections.singleton(VirtualMachineState.OFF), VirtualMachineState.OFF),
    ALLOCATE(Collections.singleton(VirtualMachineState.NOT_ALLOCATED), VirtualMachineState.ALLOCATED),
    DEALLOCATE(Collections.singleton(VirtualMachineState.ALLOCATED), VirtualMachineState.NOT_ALLOCATED);

    private Set<VirtualMachineState> origins;
    private VirtualMachineState end;
    private static final Set<VirtualMachineStateTransition> ValidVirtualMachineStateChangeTransitions;

    private VirtualMachineStateTransition(Set<VirtualMachineState> origins, VirtualMachineState end) {
        this.origins = origins;
        this.end = end;
    }

    public static VirtualMachineStateTransition getValidVirtualMachineStateChangeTransition(VirtualMachineState origin, VirtualMachineState end) {
        VirtualMachineStateTransition validTransition = null;
        for (VirtualMachineStateTransition transition : VirtualMachineStateTransition.values()) {
            if (SHUTDOWN.equals((Object)transition) || !transition.isValidOrigin(origin) || !transition.getEndState().equals((Object)end)) continue;
            validTransition = transition;
            break;
        }
        if (validTransition != null && !ValidVirtualMachineStateChangeTransitions.contains((Object)validTransition)) {
            return null;
        }
        return validTransition;
    }

    private VirtualMachineState getEndState() {
        return this.end;
    }

    private boolean isValidOrigin(VirtualMachineState origin) {
        return this.origins.contains((Object)origin);
    }

    static {
        ValidVirtualMachineStateChangeTransitions = new HashSet<VirtualMachineStateTransition>(Arrays.asList(POWEROFF, PAUSE, POWERON, RESUME));
    }
}

