/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.server.core.config;

import com.abiquo.model.transport.SingleResourceTransportDto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="license")
@XmlType(propOrder={"id", "numcores", "expiration", "code", "scalingGroupsEnabled"})
public class LicenseDto
extends SingleResourceTransportDto {
    private static final long serialVersionUID = -5635150121785191074L;
    private static final String TYPE = "application/vnd.abiquo.license";
    public static final String MEDIA_TYPE = "application/vnd.abiquo.license+json";
    public static final String SHORT_MEDIA_TYPE_JSON = "application/vnd.abiquo.license+json";
    public static final String SHORT_MEDIA_TYPE_XML = "application/vnd.abiquo.license+xml";
    public static final String MEDIA_TYPE_XML = "application/vnd.abiquo.license+xml; version=5.0";
    public static final String MEDIA_TYPE_JSON = "application/vnd.abiquo.license+json; version=5.0";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private Integer id;
    private String code;
    private Integer numcores;
    private String expiration;
    private String enabledPlugins;
    private boolean scalingGroupsEnabled;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getNumcores() {
        return this.numcores;
    }

    public void setNumcores(Integer numcores) {
        this.numcores = numcores;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public String getEnabledPlugins() {
        return this.enabledPlugins;
    }

    public void setEnabledPlugins(String enabledPlugins) {
        this.enabledPlugins = enabledPlugins;
    }

    public boolean isScalingGroupsEnabled() {
        return this.scalingGroupsEnabled;
    }

    public void setScalingGroupsEnabled(boolean scalingGroupsEnabled) {
        this.scalingGroupsEnabled = scalingGroupsEnabled;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isActive() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            Date expiration = format.parse(this.getExpiration());
            return expiration.getTime() >= System.currentTimeMillis();
        }
        catch (ParseException e) {
            throw new RuntimeException("The license expiration date cannot be parsed");
        }
    }

    @Override
    public String getBaseMediaType() {
        return "application/vnd.abiquo.license+json";
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE_JSON;
    }
}

