/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.server.core.infrastructure;

import com.abiquo.model.enumerator.MachineState;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.infrastructure.DatastoresDto;
import com.abiquo.server.core.infrastructure.network.NetworkInterfacesDto;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="machine")
@XmlType(propOrder={"id", "name", "description", "state", "type", "ip", "hostname", "ipService", "port", "virtualRamInMb", "virtualRamUsedInMb", "virtualCpuCores", "virtualCpusUsed", "user", "password", "initiatorIQN", "ipmiIP", "ipmiPort", "ipmiUser", "ipmiPassword", "datastores", "networkInterfaces", "managerIp", "managerPort", "managerUser", "managerPassword", "agentIp", "agentPort", "agentUser", "agentPassword"})
public class MachineDto
extends SingleResourceTransportDto {
    private static final long serialVersionUID = -4971248626582072165L;
    private static final String TYPE = "application/vnd.abiquo.machine";
    public static final String MEDIA_TYPE = "application/vnd.abiquo.machine+json";
    public static final String SHORT_MEDIA_TYPE_JSON = "application/vnd.abiquo.machine+json";
    public static final String SHORT_MEDIA_TYPE_XML = "application/vnd.abiquo.machine+xml";
    public static final String MEDIA_TYPE_XML = "application/vnd.abiquo.machine+xml; version=5.0";
    public static final String MEDIA_TYPE_JSON = "application/vnd.abiquo.machine+json; version=5.0";
    private Integer id;
    private String name;
    private String description;
    private Integer virtualRamInMb;
    private Integer virtualRamUsedInMb;
    private Integer virtualCpuCores;
    private Integer virtualCpusUsed;
    private MachineState state;
    private Integer port;
    private String ip;
    private String hostname;
    private String ipService;
    private String type;
    private String user;
    private String password;
    private DatastoresDto datastores;
    private NetworkInterfacesDto networkInterfaces;
    private String ipmiIP;
    private Integer ipmiPort;
    private String ipmiUser;
    private String ipmiPassword;
    private String initiatorIQN;
    private String managerIp;
    private Integer managerPort;
    private String managerUser;
    private String managerPassword;
    private String agentIp;
    private Integer agentPort;
    private String agentUser;
    private String agentPassword;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIpService() {
        return this.ipService;
    }

    public void setIpService(String ipService) {
        this.ipService = ipService;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MachineState getState() {
        return this.state;
    }

    public void setState(MachineState state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="ram")
    public Integer getVirtualRamInMb() {
        return this.getDefaultMb(this.virtualRamInMb).intValue();
    }

    public void setVirtualRamInMb(Integer virtualRamInMb) {
        this.virtualRamInMb = virtualRamInMb;
    }

    @XmlElement(name="ramUsed")
    public Integer getVirtualRamUsedInMb() {
        return this.getDefaultMb(this.virtualRamUsedInMb).intValue();
    }

    public void setVirtualRamUsedInMb(Integer virtualRamUsedInMb) {
        this.virtualRamUsedInMb = virtualRamUsedInMb;
    }

    @XmlElement(name="cpu")
    public Integer getVirtualCpuCores() {
        return (Integer)this.getDefaultMb(this.virtualCpuCores);
    }

    public void setVirtualCpuCores(Integer virtualCpuCores) {
        this.virtualCpuCores = virtualCpuCores;
    }

    @XmlElement(name="cpuUsed")
    public Integer getVirtualCpusUsed() {
        return (Integer)this.getDefaultMb(this.virtualCpusUsed);
    }

    public void setVirtualCpusUsed(Integer virtualCpusUsed) {
        this.virtualCpusUsed = virtualCpusUsed;
    }

    private Number getDefaultMb(Number mb) {
        return mb == null ? (Number)1 : (Number)mb;
    }

    public void setDatastores(DatastoresDto datastores) {
        this.datastores = datastores;
    }

    public DatastoresDto getDatastores() {
        if (this.datastores == null) {
            this.datastores = new DatastoresDto();
        }
        return this.datastores;
    }

    public String getIpmiIP() {
        return this.ipmiIP;
    }

    public void setIpmiIP(String ipmiIP) {
        this.ipmiIP = ipmiIP;
    }

    public Integer getIpmiPort() {
        return this.ipmiPort;
    }

    public void setIpmiPort(Integer ipmiPort) {
        this.ipmiPort = ipmiPort;
    }

    public String getIpmiUser() {
        return this.ipmiUser;
    }

    public void setIpmiUser(String ipmiUser) {
        this.ipmiUser = ipmiUser;
    }

    public String getIpmiPassword() {
        return this.ipmiPassword;
    }

    public void setIpmiPassword(String ipmiPassword) {
        this.ipmiPassword = ipmiPassword;
    }

    public String getInitiatorIQN() {
        return this.initiatorIQN;
    }

    public void setInitiatorIQN(String initiatorIQN) {
        this.initiatorIQN = initiatorIQN;
    }

    public NetworkInterfacesDto getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new NetworkInterfacesDto();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(NetworkInterfacesDto networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public String getManagerIp() {
        return this.managerIp;
    }

    public void setManagerIp(String managerIp) {
        this.managerIp = managerIp;
    }

    public Integer getManagerPort() {
        return this.managerPort;
    }

    public void setManagerPort(Integer managerPort) {
        this.managerPort = managerPort;
    }

    public String getManagerUser() {
        return this.managerUser;
    }

    public void setManagerUser(String managerUser) {
        this.managerUser = managerUser;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    public String getAgentIp() {
        return this.agentIp;
    }

    public void setAgentIp(String agentIp) {
        this.agentIp = agentIp;
    }

    public Integer getAgentPort() {
        return this.agentPort;
    }

    public void setAgentPort(Integer agentPort) {
        this.agentPort = agentPort;
    }

    public String getAgentUser() {
        return this.agentUser;
    }

    public void setAgentUser(String agentUser) {
        this.agentUser = agentUser;
    }

    public String getAgentPassword() {
        return this.agentPassword;
    }

    public void setAgentPassword(String agentPassword) {
        this.agentPassword = agentPassword;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public String getBaseMediaType() {
        return "application/vnd.abiquo.machine+json";
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE_JSON;
    }
}

