/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.server.core.infrastructure.network;

import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.model.transport.WithProviderId;
import com.abiquo.server.core.infrastructure.network.DhcpOptionsDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="network")
@XmlType(propOrder={"id", "name", "address", "mask", "gateway", "primaryDNS", "secondaryDNS", "sufixDNS", "tag", "defaultNetwork", "unmanaged", "type", "dhcpOptions", "ipv6", "strict", "providerId", "restricted", "internetGatewayRole", "ipRanges", "excludedFromFirewall", "notUsableLoadBalancers", "notUsableVirtualMachines", "dhcpIp"})
public class VLANNetworkDto
extends SingleResourceTransportDto
implements WithProviderId {
    private static final long serialVersionUID = 7128354911707490770L;
    private static final String TYPE = "application/vnd.abiquo.vlan";
    public static final String MEDIA_TYPE = "application/vnd.abiquo.vlan+json";
    public static final String SHORT_MEDIA_TYPE_JSON = "application/vnd.abiquo.vlan+json";
    public static final String SHORT_MEDIA_TYPE_XML = "application/vnd.abiquo.vlan+xml";
    public static final String MEDIA_TYPE_XML = "application/vnd.abiquo.vlan+xml; version=5.0";
    public static final String MEDIA_TYPE_JSON = "application/vnd.abiquo.vlan+json; version=5.0";
    private Integer id;
    private String name;
    private Integer tag;
    private String gateway;
    private String address;
    private Integer mask;
    private String primaryDNS;
    private String secondaryDNS;
    private String sufixDNS;
    private boolean defaultNetwork;
    private Boolean unmanaged;
    private NetworkType type;
    private boolean restricted;
    private DhcpOptionsDto dhcpOptions;
    private String providerId;
    private boolean ipv6;
    private boolean strict;
    private boolean internetGatewayRole;
    private List<IpRange> ipRanges = new ArrayList<IpRange>();
    private boolean excludedFromFirewall;
    private boolean notUsableLoadBalancers;
    private boolean notUsableVirtualMachines;
    private String dhcpIp;

    public String getAddress() {
        return this.address;
    }

    public boolean isDefaultNetwork() {
        return this.defaultNetwork;
    }

    public DhcpOptionsDto getDhcpOptions() {
        return this.dhcpOptions;
    }

    public String getGateway() {
        return this.gateway;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getMask() {
        return this.mask;
    }

    @XmlElement(defaultValue="")
    public String getName() {
        return this.name;
    }

    public String getPrimaryDNS() {
        return this.primaryDNS;
    }

    public String getSecondaryDNS() {
        return this.secondaryDNS;
    }

    public String getSufixDNS() {
        return this.sufixDNS;
    }

    public Integer getTag() {
        return this.tag;
    }

    public NetworkType getType() {
        return this.type;
    }

    public Boolean getUnmanaged() {
        return this.unmanaged;
    }

    public boolean isIpv6() {
        return this.ipv6;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @XmlElement(name="ipRange")
    @JsonProperty(value="ipRanges")
    public List<IpRange> getIpRanges() {
        return this.ipRanges;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setDefaultNetwork(boolean defaultNetwork) {
        this.defaultNetwork = defaultNetwork;
    }

    public void setDhcpOptions(DhcpOptionsDto dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setMask(Integer mask) {
        this.mask = mask;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryDNS(String primaryDNS) {
        this.primaryDNS = primaryDNS;
    }

    public void setSecondaryDNS(String secondaryDNS) {
        this.secondaryDNS = secondaryDNS;
    }

    public void setSufixDNS(String sufixDNS) {
        this.sufixDNS = sufixDNS;
    }

    public void setTag(Integer tag) {
        this.tag = tag;
    }

    public void setType(NetworkType type) {
        this.type = type;
    }

    public void setUnmanaged(Boolean unmanaged) {
        this.unmanaged = unmanaged;
    }

    public void setIpv6(boolean ipv6) {
        this.ipv6 = ipv6;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public boolean isInternetGatewayRole() {
        return this.internetGatewayRole;
    }

    public void setInternetGatewayRole(boolean internetGatewayRole) {
        this.internetGatewayRole = internetGatewayRole;
    }

    public void setIpRanges(List<IpRange> ipRanges) {
        this.ipRanges = ipRanges;
    }

    public boolean isExcludedFromFirewall() {
        return this.excludedFromFirewall;
    }

    public void setExcludedFromFirewall(boolean excludedFromFirewall) {
        this.excludedFromFirewall = excludedFromFirewall;
    }

    public boolean isNotUsableLoadBalancers() {
        return this.notUsableLoadBalancers;
    }

    public void setNotUsableLoadBalancers(boolean notUsableLoadBalancers) {
        this.notUsableLoadBalancers = notUsableLoadBalancers;
    }

    public boolean isNotUsableVirtualMachines() {
        return this.notUsableVirtualMachines;
    }

    public void setNotUsableVirtualMachines(boolean notUsableVirtualMachines) {
        this.notUsableVirtualMachines = notUsableVirtualMachines;
    }

    public String getDhcpIp() {
        return this.dhcpIp;
    }

    public void setDhcpIp(String dhcpIp) {
        this.dhcpIp = dhcpIp;
    }

    @Override
    public String getBaseMediaType() {
        return "application/vnd.abiquo.vlan+json";
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE_JSON;
    }

    public static class IpRange {
        private String firstIp;
        private String lastIp;

        public String getFirstIp() {
            return this.firstIp;
        }

        public String getLastIp() {
            return this.lastIp;
        }

        public void setFirstIp(String firstIp) {
            this.firstIp = firstIp;
        }

        public void setLastIp(String lastIp) {
            this.lastIp = lastIp;
        }
    }
}

