/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public abstract class BaseProcessor
extends AbstractProcessor {
    public static boolean DEBUG_MODE = false;
    public static Elements elementUtils;
    public static boolean JUNIT_TEST_MODE;
    protected static Logger logger;
    protected int count;
    protected HashSet<String> excludedMethods;
    protected Filer filer;
    protected final Map<String, TypeElement> globalBeanElements = new HashMap<String, TypeElement>();
    protected static Messager messager;
    protected Types typeUtils;

    public void clear() {
        this.globalBeanElements.clear();
    }

    public void error(Element e, String msg, Object ... args) {
        messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public Set<Element> filter(RoundEnvironment roundEnv) {
        HashSet<Element> result = new HashSet<Element>();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotationClasses()) {
            result.addAll(roundEnv.getElementsAnnotatedWith(annotation));
        }
        return result;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    protected abstract Set<Class<? extends Annotation>> getSupportedAnnotationClasses();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> result = new HashSet<String>();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotationClasses()) {
            result.add(annotation.getCanonicalName());
        }
        return result;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean hasWorkInThisRound(RoundEnvironment roundEnv) {
        return this.filter(roundEnv).size() > 0;
    }

    public static void info(String msg, Object ... args) {
        if (JUNIT_TEST_MODE) {
            logger.info(String.format(msg, args));
        }
        if (!JUNIT_TEST_MODE && DEBUG_MODE) {
            messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        messager = processingEnv.getMessager();
        this.typeUtils = processingEnv.getTypeUtils();
        this.excludedMethods = new HashSet();
        this.excludedMethods.add("wait");
        this.excludedMethods.add("notifyAll");
        this.excludedMethods.add("notify");
        this.excludedMethods.add("toString");
        this.excludedMethods.add("equals");
        this.excludedMethods.add("hashCode");
        this.excludedMethods.add("getClass");
        this.count = 0;
        this.clear();
    }

    protected void parseBindType(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(BindType.class)) {
            AssertKripton.assertTrueOrInvalidKindForAnnotationException(element.getKind() == ElementKind.CLASS, element, BindType.class);
            this.globalBeanElements.put(element.toString(), (TypeElement)element);
        }
    }

    static {
        JUNIT_TEST_MODE = false;
        logger = Logger.getGlobal();
    }
}

