/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.android.ColumnAffinityType;
import com.abubusoft.kripton.android.ColumnType;
import com.abubusoft.kripton.android.annotation.BindContentProvider;
import com.abubusoft.kripton.android.annotation.BindContentProviderEntry;
import com.abubusoft.kripton.android.annotation.BindContentProviderPath;
import com.abubusoft.kripton.android.annotation.BindDao;
import com.abubusoft.kripton.android.annotation.BindDaoMany2Many;
import com.abubusoft.kripton.android.annotation.BindDataSource;
import com.abubusoft.kripton.android.annotation.BindDataSourceOptions;
import com.abubusoft.kripton.android.annotation.BindGeneratedDao;
import com.abubusoft.kripton.android.annotation.BindSqlAdapter;
import com.abubusoft.kripton.android.annotation.BindSqlChildSelect;
import com.abubusoft.kripton.android.annotation.BindSqlColumn;
import com.abubusoft.kripton.android.annotation.BindSqlDelete;
import com.abubusoft.kripton.android.annotation.BindSqlInsert;
import com.abubusoft.kripton.android.annotation.BindSqlRelation;
import com.abubusoft.kripton.android.annotation.BindSqlSelect;
import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.android.annotation.BindSqlUpdate;
import com.abubusoft.kripton.android.sqlite.ForeignKeyAction;
import com.abubusoft.kripton.android.sqlite.NoPopulator;
import com.abubusoft.kripton.annotation.BindDisabled;
import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.common.One;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.common.Triple;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.KriptonOptions;
import com.abubusoft.kripton.processor.bind.BindEntityBuilder;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.model.many2many.M2MEntity;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.Touple;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.PropertyFactory;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.element.GeneratedTypeElement;
import com.abubusoft.kripton.processor.exceptions.DaoDefinitionWithoutAnnotatedMethodException;
import com.abubusoft.kripton.processor.exceptions.InvalidBeanTypeException;
import com.abubusoft.kripton.processor.exceptions.InvalidDefinition;
import com.abubusoft.kripton.processor.exceptions.InvalidKindForAnnotationException;
import com.abubusoft.kripton.processor.exceptions.InvalidNameException;
import com.abubusoft.kripton.processor.exceptions.NoDaoElementFound;
import com.abubusoft.kripton.processor.exceptions.PropertyNotFoundException;
import com.abubusoft.kripton.processor.exceptions.SQLPrimaryKeyNotFoundException;
import com.abubusoft.kripton.processor.exceptions.SQLPrimaryKeyNotValidTypeException;
import com.abubusoft.kripton.processor.exceptions.TooManySQLPrimaryKeyFoundException;
import com.abubusoft.kripton.processor.sqlite.BindAsyncTaskBuilder;
import com.abubusoft.kripton.processor.sqlite.BindContentProviderBuilder;
import com.abubusoft.kripton.processor.sqlite.BindCursorBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDaoBuilder;
import com.abubusoft.kripton.processor.sqlite.BindDataSourceBuilder;
import com.abubusoft.kripton.processor.sqlite.BindTableGenerator;
import com.abubusoft.kripton.processor.sqlite.SelectBuilderUtility;
import com.abubusoft.kripton.processor.sqlite.SqlAnalyzer;
import com.abubusoft.kripton.processor.sqlite.SqlBuilderHelper;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQL;
import com.abubusoft.kripton.processor.sqlite.grammars.jql.JQLChecker;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlBaseListener;
import com.abubusoft.kripton.processor.sqlite.grammars.jsql.JqlParser;
import com.abubusoft.kripton.processor.sqlite.model.SQLProperty;
import com.abubusoft.kripton.processor.sqlite.model.SQLRelationType;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDaoDefinition;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteDatabaseSchema;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteEntity;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelContentProvider;
import com.abubusoft.kripton.processor.sqlite.model.SQLiteModelMethod;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class BindDataSourceSubProcessor
extends BaseProcessor {
    private static BindDataSourceSubProcessor instance;
    private final AnnotationUtility.AnnotationFilter propertyAnnotationFilter = AnnotationUtility.AnnotationFilter.builder().add(BindDisabled.class).add(BindSqlColumn.class).add(BindSqlAdapter.class).add(BindSqlRelation.class).build();
    public final Map<String, TypeElement> globalDaoElements = new HashMap<String, TypeElement>();
    public Set<TypeElement> dataSets;
    public LinkedHashSet<SQLiteDatabaseSchema> schemas = new LinkedHashSet();
    public Set<String> globalDaoGenerated = new HashSet<String>();
    public Set<GeneratedTypeElement> generatedDaos;
    public Set<GeneratedTypeElement> generatedEntities;

    public static BindDataSourceSubProcessor getInstance() {
        return instance;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> result = new HashSet<String>();
        result.add(KriptonOptions.SCHEMA_LOCATION_OPTIONS);
        result.add(KriptonOptions.ANDROID_X_OPTIONS);
        return result;
    }

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotationClasses() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(BindType.class);
        annotations.add(BindDataSource.class);
        annotations.add(BindDataSourceOptions.class);
        annotations.add(BindSqlType.class);
        annotations.add(BindDao.class);
        annotations.add(BindDaoMany2Many.class);
        annotations.add(BindGeneratedDao.class);
        return annotations;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        instance = this;
    }

    @Override
    public void clear() {
        super.clear();
        this.dataSets = new HashSet<TypeElement>();
        this.generatedDaos = null;
        this.generatedEntities = null;
        this.globalDaoElements.clear();
        this.schemas = new LinkedHashSet();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement dataSource : this.dataSets) {
            SQLiteDatabaseSchema currentSchema = this.createDataSource(dataSource);
            for (String daoName : currentSchema.getDaoNameSet()) {
                this.createSQLEntityFromDao(currentSchema, dataSource, daoName);
            }
            Collections.sort(currentSchema.getCollection(), new Comparator<SQLiteDaoDefinition>(){

                @Override
                public int compare(SQLiteDaoDefinition o1, SQLiteDaoDefinition o2) {
                    return o1.getTableName().compareTo(o2.getTableName());
                }
            });
            for (String generatedDaoItem : currentSchema.getDaoNameSet()) {
                this.createSQLDaoDefinition(currentSchema, this.globalBeanElements, this.globalDaoElements, generatedDaoItem);
            }
            this.analyzeForeignKey(currentSchema);
            this.analyzeRelations(currentSchema);
            this.analyzeCustomBeanForSelect(currentSchema);
            if (currentSchema.getCollection().size() == 0) {
                AssertKripton.fail("DataSource class %s with @%s annotation has no defined DAOs", ((TypeElement)currentSchema.getElement()).getSimpleName().toString(), BindDataSource.class.getSimpleName(), BindDao.class.getSimpleName());
                return true;
            }
            int uid = 0;
            for (SQLiteDaoDefinition daoDefinition : currentSchema.getCollection()) {
                String daoFieldName;
                daoDefinition.daoUidName = daoFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, daoDefinition.getName()) + "_UID";
                daoDefinition.daoUidValue = uid++;
            }
            this.schemas.add(currentSchema);
        }
        return true;
    }

    private void analyzeCustomBeanForSelect(SQLiteDatabaseSchema schema) {
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            for (SQLiteModelMethod method : dao.getCollection()) {
                if (!method.hasCustomProjection()) continue;
                SQLiteEntity entity = method.getEntity();
                AssertKripton.assertTrueOrInvalidMethodSignException(schema.getEntity(entity.getName()) == null, method, "'%s' must be read with its DAO", entity.getSimpleName());
                AssertKripton.assertTrueOrInvalidMethodSignException(method.jql.declarationType == JQL.JQLDeclarationType.JQL_EXPLICIT, method, "select with custom projection must be declared with explicit JQL", new Object[0]);
            }
        }
    }

    private void analyzeRelations(SQLiteDatabaseSchema schema) {
        for (SQLiteEntity entity : schema.getEntities()) {
            if (entity.relations.size() == 0) continue;
            for (Touple<SQLProperty, String, SQLiteEntity, SQLRelationType> item : entity.relations) {
                SQLiteEntity referredEntity;
                TypeName typeName = TypeUtility.typeName(((SQLProperty)item.value0).getElement());
                if (TypeUtility.isSet(typeName) || TypeUtility.isList(typeName)) {
                    AssertKripton.assertTrueOfInvalidDefinition(((ParameterizedTypeName)typeName).typeArguments.size() == 1, (SQLProperty)item.value0, String.format("invalid type for @%s annotated element", BindSqlRelation.class.getSimpleName()));
                    typeName = (TypeName)((ParameterizedTypeName)typeName).typeArguments.get(0);
                    referredEntity = schema.getEntity(typeName.toString());
                    this.checkForeignKeyContraint(entity, item, referredEntity);
                    item.value2 = referredEntity;
                    item.value3 = SQLRelationType.ONE_2_MANY;
                } else {
                    referredEntity = schema.getEntity(typeName.toString());
                    this.checkForeignKeyContraint(entity, item, referredEntity);
                    item.value2 = referredEntity;
                    item.value3 = SQLRelationType.ONE_2_ONE;
                }
                SQLiteDaoDefinition parentDaoDefinition = schema.findDaoDefinitionForEntity(entity);
                for (final SQLiteModelMethod method : parentDaoDefinition.getCollection()) {
                    if (!method.hasChildrenSelects()) continue;
                    for (Triple<String, String, SQLiteModelMethod> childrenSelect : method.childrenSelects) {
                        Touple<SQLProperty, String, SQLiteEntity, SQLRelationType> relation = entity.findRelationByParentProperty((String)childrenSelect.value0);
                        AssertKripton.assertTrueOrInvalidMethodSignException(relation != null, method, " property '%s#%s' does not exits (referred by annotation @%s(%s='%s', %s='%s'))", entity.getSimpleName(), childrenSelect.value0, BindSqlChildSelect.class.getSimpleName(), AnnotationAttributeType.FIELD.getValue(), childrenSelect.value0, AnnotationAttributeType.METHOD.getValue(), childrenSelect.value1);
                        final SQLiteDaoDefinition childDaoDefinition = schema.findDaoDefinitionForEntity((SQLiteEntity)relation.value2);
                        AssertKripton.assertTrueOrInvalidMethodSignException(childDaoDefinition != null, method, " dao for entity '%s', referred by @%s annotation, does not exists", relation.value2, BindSqlChildSelect.class.getSimpleName());
                        final SQLiteModelMethod subMethod = (SQLiteModelMethod)childDaoDefinition.get((String)childrenSelect.value1);
                        AssertKripton.assertTrueOrInvalidMethodSignException(subMethod != null, method, " method '%s#%s', referred by @%s annotation, does not exists", ((TypeElement)childDaoDefinition.getElement()).getSimpleName().toString(), childrenSelect.value1, BindSqlChildSelect.class.getSimpleName());
                        AssertKripton.assertTrueOrInvalidMethodSignException(subMethod.getParameters().size() == 1, method, " method '%s#%s', referred by annotation @%s(%s='%s', %s='%s'), can have only one parameter", childDaoDefinition.getTypeName(), subMethod.getName(), BindSqlChildSelect.class.getSimpleName(), AnnotationAttributeType.FIELD.getValue(), childrenSelect.value0, AnnotationAttributeType.METHOD.getValue(), childrenSelect.value1);
                        childrenSelect.value2 = subMethod;
                        final String defaultConditionToTest1 = (String)relation.value1 + "=" + SqlAnalyzer.PARAM_PREFIX + subMethod.findParameterAliasByName((String)subMethod.getParameters().get((int)0).value0) + SqlAnalyzer.PARAM_SUFFIX;
                        final String defaultConditionToTest2 = SqlAnalyzer.PARAM_PREFIX + subMethod.findParameterAliasByName((String)subMethod.getParameters().get((int)0).value0) + SqlAnalyzer.PARAM_SUFFIX + "=" + (String)relation.value1;
                        final HashSet<String> conditionToTest = new HashSet<String>();
                        String[] prefix = new String[]{"${", ":{", ":"};
                        String[] suffix = new String[]{"}", "}", ""};
                        for (int i = 0; i < prefix.length; ++i) {
                            String conditionToTest1 = (String)relation.value1 + "=" + prefix[i] + subMethod.findParameterAliasByName((String)subMethod.getParameters().get((int)0).value0) + suffix[i];
                            String conditionToTest2 = prefix[i] + subMethod.findParameterAliasByName((String)subMethod.getParameters().get((int)0).value0) + suffix[i] + "=" + (String)relation.value1;
                            conditionToTest.add(conditionToTest1);
                            conditionToTest.add(conditionToTest2);
                        }
                        JQLChecker.getInstance().analyze(subMethod, subMethod.jql, new JqlBaseListener(){

                            @Override
                            public void enterWhere_stmt_clauses(JqlParser.Where_stmt_clausesContext ctx) {
                                boolean found = false;
                                for (String item : conditionToTest) {
                                    if (!ctx.getText().contains(item)) continue;
                                    found = true;
                                }
                                AssertKripton.assertTrueOrInvalidMethodSignException(found, method, " method '%s#%s' referred by @%s annotation must have a where condition like '%s' or '%s'", childDaoDefinition.getTypeName(), subMethod.getName(), BindSqlChildSelect.class.getSimpleName(), defaultConditionToTest1, defaultConditionToTest2);
                            }
                        });
                        AssertKripton.assertTrueOrInvalidMethodSignException(TypeUtility.isEquals((TypeName)subMethod.getParameters().get((int)0).value1, entity.getPrimaryKey().getPropertyType().getTypeName()), method, " method '%s#%s' referred by annotation @%s(%s='%s', %s='%s') has invalid parameter type ", childDaoDefinition.getTypeName(), subMethod.getName(), BindSqlChildSelect.class.getSimpleName(), AnnotationAttributeType.FIELD.getValue(), childrenSelect.value0, AnnotationAttributeType.METHOD.getValue(), childrenSelect.value1);
                        TypeName parentFieldTypeName = ((SQLProperty)relation.value0).getPropertyType().getTypeName();
                        AssertKripton.assertTrueOrInvalidMethodSignException(parentFieldTypeName.equals((Object)subMethod.getReturnClass()) || TypeUtility.isList(parentFieldTypeName) == TypeUtility.isList(subMethod.getReturnClass()) && TypeUtility.isSet(parentFieldTypeName) == TypeUtility.isSet(subMethod.getReturnClass()), method, "field '%s#%s' is incompatible with '%s#%s' referred by @%s annotation ", TypeUtility.typeName(((SQLProperty)relation.value0).getParent().getElement()).toString(), ((SQLProperty)relation.value0).getName(), childDaoDefinition.getTypeName(), childrenSelect.value1, BindSqlChildSelect.class.getSimpleName());
                        AssertKripton.assertTrueOrInvalidMethodSignException(subMethod != null, method, "an nonexistent method '%s#%s' is referred by @%s annotation ", childDaoDefinition.getTypeName(), relation.value1, BindSqlChildSelect.class.getSimpleName());
                        AssertKripton.assertTrueOrInvalidMethodSignException(subMethod.getParameters().size() == 1, method, " method '%s#%s' referred by @%s annotation can have one parameter binded to %s property", childDaoDefinition.getTypeName(), relation.value1, BindSqlChildSelect.class.getSimpleName(), relation.value1);
                        AssertKripton.assertTrueOrInvalidMethodSignException(TypeUtility.isTypeIncludedIn((TypeName)subMethod.getParameters().get((int)0).value1, new Type[]{Long.TYPE, Long.class, String.class}), method, " method '%s#%s' referred by @%s annotation can have only one parameter of type String, Long or long", childDaoDefinition.getTypeName(), relation.value1, BindSqlChildSelect.class.getSimpleName(), relation.value1);
                        SelectBuilderUtility.SelectType selectSubMethodResultType = SelectBuilderUtility.detectSelectType(subMethod);
                        switch ((SQLRelationType)((Object)relation.value3)) {
                            case ONE_2_MANY: {
                                AssertKripton.assertTrueOrInvalidMethodSignException(selectSubMethodResultType == SelectBuilderUtility.SelectType.LIST_BEAN, method, " method '%s#%s' referred by @%s annotation does not return an acceptable value from '%s' property", childDaoDefinition.getTypeName(), relation.value1, BindSqlChildSelect.class.getSimpleName(), relation.value1);
                                break;
                            }
                            case ONE_2_ONE: {
                                AssertKripton.assertTrueOrInvalidMethodSignException(selectSubMethodResultType == SelectBuilderUtility.SelectType.BEAN, method, " method '%s#%s' referred by @%s annotation does not return an acceptable value from '%s' property", childDaoDefinition.getTypeName(), relation.value1, BindSqlChildSelect.class.getSimpleName(), relation.value1);
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkForeignKeyContraint(SQLiteEntity entity, Touple<SQLProperty, String, SQLiteEntity, SQLRelationType> item, SQLiteEntity referredEntity) {
        AssertKripton.assertTrueOfInvalidDefinition(referredEntity != null, (SQLProperty)item.value0, String.format("invalid type for @%s annotated element", BindSqlRelation.class.getSimpleName()));
        List<SQLProperty> foreignKeyPropertyList = referredEntity.getForeignKeysToEntity(entity, (String)item.value1);
        AssertKripton.assertTrueOfInvalidDefinition(foreignKeyPropertyList.size() == 1, (SQLProperty)item.value0, String.format("@%s#%s need to specify a valid foreign key to entity '%s'", BindSqlRelation.class.getSimpleName(), AnnotationAttributeType.FOREIGN_KEY.getValue(), referredEntity.getName()));
        if (!StringUtils.hasText((String)((String)item.value1))) {
            item.value1 = foreignKeyPropertyList.get(0).getName();
        }
        SQLProperty foreignKey = (SQLProperty)referredEntity.get((String)item.value1);
        AssertKripton.assertTrueOfInvalidDefinition(TypeUtility.isEquals(entity.getPrimaryKey().getPropertyType().getTypeName(), foreignKey.getPropertyType().getTypeName()), (SQLProperty)item.value0, String.format("%s#%s is a foreign key to %s#%s: they have to be same type", referredEntity.getName(), foreignKey.getName(), entity.getName(), entity.getPrimaryKey().getName()));
    }

    public boolean processSecondRound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (SQLiteDatabaseSchema schema : this.schemas) {
            for (String daoName : schema.getDaoNameSet()) {
                if (!this.globalDaoGenerated.contains(daoName)) continue;
                this.createSQLEntityFromDao(schema, (TypeElement)schema.getElement(), daoName);
                this.createSQLDaoDefinition(schema, this.globalBeanElements, this.globalDaoElements, daoName);
            }
        }
        return true;
    }

    public boolean analyzeSecondRound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.parseBindType(roundEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(BindSqlType.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                String string = String.format("%s %s, only class can be annotated with @%s annotation", new Object[]{element.getKind(), element, BindSqlType.class.getSimpleName()});
                throw new InvalidKindForAnnotationException(string);
            }
            this.globalBeanElements.put(element.toString(), (TypeElement)element);
        }
        Set<? extends Element> generatedDaos = roundEnv.getElementsAnnotatedWith(BindGeneratedDao.class);
        for (Element element : generatedDaos) {
            String keyToReplace = AnnotationUtility.extractAsClassName(element, BindGeneratedDao.class, AnnotationAttributeType.DAO);
            this.globalDaoElements.put(keyToReplace, (TypeElement)element);
            this.globalDaoGenerated.add(keyToReplace);
        }
        return false;
    }

    public boolean analyzeRound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.parseBindType(roundEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(BindSqlType.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                String msg = String.format("%s %s, only class can be annotated with @%s annotation", new Object[]{element.getKind(), element, BindSqlType.class.getSimpleName()});
                throw new InvalidKindForAnnotationException(msg);
            }
            this.globalBeanElements.put(element.toString(), (TypeElement)element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BindDao.class)) {
            if (element.getAnnotation(BindGeneratedDao.class) != null) continue;
            if (element.getKind() != ElementKind.INTERFACE) {
                String msg = String.format("%s %s can not be annotated with @%s annotation, because it is not an interface", new Object[]{element.getKind(), element, BindDao.class.getSimpleName()});
                throw new InvalidKindForAnnotationException(msg);
            }
            this.globalDaoElements.put(element.toString(), (TypeElement)element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BindDaoMany2Many.class)) {
            if (element.getKind() != ElementKind.INTERFACE) {
                String msg = String.format("%s %s can not be annotated with @%s annotation, because it is not an interface", new Object[]{element.getKind(), element, BindDaoMany2Many.class.getSimpleName()});
                throw new InvalidKindForAnnotationException(msg);
            }
            this.globalDaoElements.put(element.toString(), (TypeElement)element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(BindDataSource.class)) {
            this.dataSets.add((TypeElement)element);
        }
        if (this.dataSets.size() == 0) {
            return false;
        }
        if (this.globalDaoElements.size() == 0) {
            throw new NoDaoElementFound();
        }
        return false;
    }

    private void analyzeForeignKey(SQLiteDatabaseSchema schema) {
        for (SQLiteEntity entity : schema.getEntities()) {
            for (SQLProperty property : entity.getCollection()) {
                if (!property.isForeignKey()) continue;
                SQLiteEntity reference = schema.getEntity(property.foreignParentClassName);
                AssertKripton.asserTrueOrUnspecifiedBeanException(reference != null, schema, entity, property.foreignParentClassName);
                if (entity.equals(reference)) continue;
                entity.referedEntities.add(reference);
            }
        }
        for (SQLiteDaoDefinition dao : schema.getCollection()) {
            if (((TypeElement)dao.getElement()).getAnnotation(BindDaoMany2Many.class) == null) continue;
            ClassName entity1 = TypeUtility.className(AnnotationUtility.extractAsClassName(dao.getElement(), BindDaoMany2Many.class, AnnotationAttributeType.ENTITY_1));
            ClassName entity2 = TypeUtility.className(AnnotationUtility.extractAsClassName(dao.getElement(), BindDaoMany2Many.class, AnnotationAttributeType.ENTITY_2));
            if (dao.getEntity() == null) continue;
            this.checkForeignKeyForM2M(schema, dao.getEntity(), entity1);
            this.checkForeignKeyForM2M(schema, dao.getEntity(), entity2);
        }
    }

    private boolean isGeneratedEntity(String fullName) {
        for (GeneratedTypeElement item : this.generatedEntities) {
            if (!item.getQualifiedName().equals(fullName)) continue;
            return true;
        }
        return false;
    }

    private boolean createSQLEntityFromDao(SQLiteDatabaseSchema schema, TypeElement dataSource, String daoName) {
        TypeElement daoElement = this.globalDaoElements.get(daoName);
        if (daoElement == null) {
            String msg = String.format("Data source %s references a DAO %s without @%s annotation", dataSource.toString(), daoName, BindDao.class.getSimpleName());
            throw new InvalidNameException(msg);
        }
        String entityClassName = AnnotationUtility.extractAsClassName(daoElement, BindDao.class, AnnotationAttributeType.VALUE);
        if (!StringUtils.hasText((String)entityClassName)) {
            return false;
        }
        SQLiteEntity currentEntity = this.createSQLEntity(schema, daoElement, entityClassName);
        if (!schema.contains(currentEntity.getName())) {
            schema.addEntity(currentEntity);
        }
        return true;
    }

    public SQLiteEntity createSQLEntity(final SQLiteDatabaseSchema schema, TypeElement daoElement, String beanClassName) {
        TypeElement beanElement = (TypeElement)this.globalBeanElements.get(beanClassName);
        AssertKripton.asserTrueOrMissedAnnotationOnClassException(beanElement != null, daoElement, beanClassName);
        final BindEntity bindEntity = BindEntityBuilder.parse(null, beanElement);
        SQLiteEntity currentEntity = new SQLiteEntity(schema, bindEntity);
        final boolean bindAllFields = AnnotationUtility.getAnnotationAttributeAsBoolean(currentEntity, BindType.class, AnnotationAttributeType.ALL_FIELDS, Boolean.TRUE);
        PropertyUtility.buildProperties(elementUtils, currentEntity, new PropertyFactory<SQLiteEntity, SQLProperty>(){

            @Override
            public SQLProperty createProperty(SQLiteEntity entity, Element propertyElement) {
                return new SQLProperty(entity, propertyElement, AnnotationUtility.buildAnnotationList(propertyElement));
            }
        }, this.propertyAnnotationFilter, new PropertyUtility.PropertyCreatedListener<SQLiteEntity, SQLProperty>(){

            @Override
            public boolean onProperty(SQLiteEntity entity, SQLProperty property) {
                if (property.hasAnnotation(BindDisabled.class)) {
                    if (bindAllFields) {
                        return false;
                    }
                    throw new InvalidDefinition(String.format("@%s can not be used with @%s(allFields=false)", BindDisabled.class, BindType.class));
                }
                ModelAnnotation annotationBindColumn = property.getAnnotation(BindSqlColumn.class);
                if (annotationBindColumn != null && !AnnotationUtility.extractAsBoolean(property, annotationBindColumn, AnnotationAttributeType.ENABLED)) {
                    return false;
                }
                if (!bindAllFields && annotationBindColumn == null) {
                    return false;
                }
                if (property.hasAnnotation(BindSqlRelation.class)) {
                    ModelAnnotation annotationBindRelation = property.getAnnotation(BindSqlRelation.class);
                    AssertKripton.assertTrueOfInvalidDefinition(annotationBindColumn == null, property, String.format("annotations @%s and @%s can not be used together", BindSqlRelation.class.getSimpleName(), BindSqlColumn.class.getSimpleName()));
                    entity.relations.add(new Touple<SQLProperty, String, Object, Object>(property, annotationBindRelation.getAttribute(AnnotationAttributeType.FOREIGN_KEY), null, null));
                    return false;
                }
                if (annotationBindColumn != null) {
                    String msg;
                    String parentClassName;
                    property.setNullable(AnnotationUtility.extractAsBoolean(property, annotationBindColumn, AnnotationAttributeType.NULLABLE));
                    ColumnType columnType = ColumnType.valueOf((String)AnnotationUtility.extractAsEnumerationValue(property, annotationBindColumn, AnnotationAttributeType.COLUMN_TYPE));
                    property.columnAffinityType = ColumnAffinityType.valueOf((String)AnnotationUtility.extractAsEnumerationValue(property, annotationBindColumn, AnnotationAttributeType.COLUMN_AFFINITY));
                    property.columnType = columnType;
                    property.setPrimaryKey(columnType == ColumnType.PRIMARY_KEY || columnType == ColumnType.PRIMARY_KEY_UNMANGED);
                    property.foreignParentClassName = parentClassName = annotationBindColumn.getAttributeAsClassName(AnnotationAttributeType.PARENT_ENTITY);
                    if (property.isForeignKey() && property.columnType == ColumnType.PRIMARY_KEY) {
                        AssertKripton.failIncompatibleAttributesInAnnotationException("In class '%s' property '%s' can not be defined as PRIMARY KEY and FOREIGN KEY", ((TypeElement)bindEntity.getElement()).asType(), property.getName());
                    }
                    ForeignKeyAction onDeleteAction = ForeignKeyAction.valueOf((String)AnnotationUtility.extractAsEnumerationValue(property, annotationBindColumn, AnnotationAttributeType.ON_DELETE));
                    ForeignKeyAction onUpdateAction = ForeignKeyAction.valueOf((String)AnnotationUtility.extractAsEnumerationValue(property, annotationBindColumn, AnnotationAttributeType.ON_UPDATE));
                    if (!property.isForeignKey() && onDeleteAction != ForeignKeyAction.NO_ACTION) {
                        msg = String.format("In class '%s', property '%s' defines 'onDelete' attribute but it is not a foreign key", ((TypeElement)bindEntity.getElement()).asType(), property.getName());
                        AssertKripton.failIncompatibleAttributesInAnnotationException(msg, new Object[0]);
                    }
                    if (!property.isForeignKey() && onUpdateAction != ForeignKeyAction.NO_ACTION) {
                        msg = String.format("In class '%s', property '%s' defines 'onUpdate' attribute but it is not a foreign key", ((TypeElement)bindEntity.getElement()).asType(), property.getName());
                        AssertKripton.failIncompatibleAttributesInAnnotationException(msg, new Object[0]);
                    }
                    property.onDeleteAction = onDeleteAction;
                    property.onUpdateAction = onUpdateAction;
                } else {
                    property.setNullable(true);
                    property.columnType = ColumnType.STANDARD;
                }
                if (bindEntity.contains(property.getName())) {
                    BindProperty bindProperty = (BindProperty)bindEntity.get(property.getName());
                    if (bindProperty.isBindedArray() || bindProperty.isBindedCollection() || bindProperty.isBindedMap() || bindProperty.isBindedObject()) {
                        property.bindProperty = bindProperty;
                    }
                } else {
                    throw new KriptonRuntimeException(String.format("In class '%s' property '%s' has a wrong definition for create SQLite DataSource", ((TypeElement)bindEntity.getElement()).asType(), property.getName()));
                }
                String columnName = null;
                if (annotationBindColumn != null) {
                    columnName = annotationBindColumn.getAttribute(AnnotationAttributeType.VALUE);
                }
                if (!StringUtils.hasText(columnName)) {
                    columnName = property.getName();
                }
                property.columnName = (String)schema.columnNameConverter.convert((Object)columnName);
                return true;
            }
        });
        SQLProperty primaryKey = currentEntity.getPrimaryKey();
        if (primaryKey != null) {
            primaryKey.setPrimaryKey(true);
            if (primaryKey.columnType != ColumnType.PRIMARY_KEY && primaryKey.columnType != ColumnType.PRIMARY_KEY_UNMANGED) {
                primaryKey.columnType = ColumnType.PRIMARY_KEY;
            }
            primaryKey.setNullable(false);
            if (TypeUtility.isString(primaryKey.getPropertyType().getTypeName())) {
                primaryKey.columnType = ColumnType.PRIMARY_KEY_UNMANGED;
            }
        }
        if (currentEntity.getCollection().size() == 0) {
            String msg = String.format("Class '%s', used in %s database definition, has no property!", currentEntity.getName(), ((TypeElement)schema.getElement()).getSimpleName().toString());
            throw new PropertyNotFoundException(msg);
        }
        if (currentEntity.countPrimaryKeys() > 1) {
            throw new TooManySQLPrimaryKeyFoundException(currentEntity);
        }
        SQLProperty property = currentEntity.getPrimaryKey();
        if (property == null) {
            throw new SQLPrimaryKeyNotFoundException(currentEntity);
        }
        if (!property.isType(new Type[]{Long.TYPE, Long.class, String.class})) {
            throw new SQLPrimaryKeyNotValidTypeException(currentEntity, property);
        }
        List properties = currentEntity.getCollection();
        Collections.sort(properties, new Comparator<SQLProperty>(){

            @Override
            public int compare(SQLProperty o1, SQLProperty o2) {
                if (o1.isPrimaryKey()) {
                    return -1;
                }
                if (o2.isPrimaryKey()) {
                    return 1;
                }
                return o1.columnName.compareTo(o2.columnName);
            }
        });
        for (int i = 1; i < properties.size(); ++i) {
            if (!((SQLProperty)properties.get(i)).isPrimaryKey()) continue;
            SQLProperty temp = (SQLProperty)properties.get(0);
            properties.set(0, properties.get(i));
            properties.set(i, temp);
            break;
        }
        ImmutableUtility.buildConstructors(elementUtils, currentEntity);
        return currentEntity;
    }

    private void checkForeignKeyForM2M(SQLiteDatabaseSchema currentSchema, SQLiteEntity currentEntity, ClassName m2mEntity) {
        if (m2mEntity != null) {
            SQLiteEntity temp = currentSchema.getEntity(m2mEntity.toString());
            AssertKripton.asserTrueOrForeignKeyNotFound(currentEntity.referedEntities.contains(temp), currentEntity, m2mEntity);
        }
    }

    protected void generateClasses(RoundEnvironment roundEnv) throws Exception {
        for (SQLiteDatabaseSchema currentSchema : this.schemas) {
            BindTableGenerator.generate(elementUtils, this.filer, currentSchema, currentSchema.generatedEntities);
            BindDaoBuilder.generate(elementUtils, this.filer, currentSchema);
            if (currentSchema.generateCursor) {
                BindCursorBuilder.generate(elementUtils, this.filer, currentSchema);
            }
            if (currentSchema.generateAsyncTask) {
                BindAsyncTaskBuilder.generate(elementUtils, this.filer, currentSchema);
            }
            BindDataSourceBuilder.generate(elementUtils, this.filer, currentSchema);
            if (!currentSchema.generateContentProvider) continue;
            BindContentProviderBuilder.generate(elementUtils, this.filer, currentSchema);
        }
    }

    protected void generateClassesSecondRound(RoundEnvironment roundEnv) throws Exception {
        for (SQLiteDatabaseSchema currentSchema : this.schemas) {
            BindDaoBuilder.generateSecondRound(elementUtils, this.filer, currentSchema);
        }
    }

    protected void createSQLDaoDefinition(SQLiteDatabaseSchema schema, Map<String, TypeElement> globalBeanElements, Map<String, TypeElement> globalDaoElements, String daoItem) {
        Element daoElement = globalDaoElements.get(daoItem);
        if (daoElement.getKind() != ElementKind.INTERFACE) {
            String msg = String.format("Class %s: only interfaces can be annotated with @%s annotation", daoElement.getSimpleName().toString(), BindDao.class.getSimpleName());
            throw new InvalidKindForAnnotationException(msg);
        }
        M2MEntity entity = M2MEntity.extractEntityManagedByDAO((TypeElement)daoElement);
        for (GeneratedTypeElement genItem : this.generatedEntities) {
            if (!genItem.getQualifiedName().equals(entity.getQualifiedName())) continue;
            schema.generatedEntities.add(genItem);
        }
        boolean generated = daoElement.getAnnotation(BindGeneratedDao.class) != null;
        SQLiteDaoDefinition currentDaoDefinition = new SQLiteDaoDefinition(schema, daoItem, (TypeElement)daoElement, entity.getClassName().toString(), generated);
        BindContentProviderPath daoContentProviderPath = daoElement.getAnnotation(BindContentProviderPath.class);
        if (daoContentProviderPath != null) {
            currentDaoDefinition.contentProviderEnabled = true;
            currentDaoDefinition.contentProviderPath = daoContentProviderPath.path();
            currentDaoDefinition.contentProviderTypeName = daoContentProviderPath.typeName();
            if (StringUtils.isEmpty((String)currentDaoDefinition.contentProviderTypeName)) {
                Converter convert = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
                AssertKripton.assertTrue(currentDaoDefinition.getParent().contentProvider != null, "DAO '%s' has an inconsistent content provider definition, perhaps you forget to use @%s in data source interface?", ((TypeElement)currentDaoDefinition.getElement()).getQualifiedName(), BindContentProvider.class.getSimpleName());
                currentDaoDefinition.contentProviderTypeName = currentDaoDefinition.getParent().contentProvider.authority + "." + (String)convert.convert((Object)currentDaoDefinition.getSimpleEntityClassName());
            }
        }
        if (!globalBeanElements.containsKey(currentDaoDefinition.getEntityClassName()) && !this.isGeneratedEntity(currentDaoDefinition.getEntityClassName())) {
            throw new InvalidBeanTypeException(currentDaoDefinition);
        }
        schema.add(currentDaoDefinition);
        this.fillMethods(currentDaoDefinition, daoElement);
        BindDaoMany2Many daoMany2Many = daoElement.getAnnotation(BindDaoMany2Many.class);
        if (currentDaoDefinition.getCollection().size() == 0 && daoMany2Many == null) {
            throw new DaoDefinitionWithoutAnnotatedMethodException(currentDaoDefinition);
        }
    }

    private void fillMethods(final SQLiteDaoDefinition currentDaoDefinition, Element daoElement) {
        final One methodWithAnnotation = new One((Object)false);
        SqlBuilderHelper.forEachMethods((TypeElement)daoElement, new AnnotationUtility.MethodFoundListener(){

            @Override
            public void onMethod(ExecutableElement element) {
                if (BindDataSourceSubProcessor.this.excludedMethods.contains(element.getSimpleName().toString())) {
                    return;
                }
                methodWithAnnotation.value0 = false;
                final ArrayList<ModelAnnotation> annotationList = new ArrayList<ModelAnnotation>();
                ArrayList supportAnnotationList = new ArrayList();
                AnnotationUtility.forEachAnnotations(element, new AnnotationUtility.AnnotationFoundListener(){

                    @Override
                    public void onAcceptAnnotation(Element element, String annotationClassName, Map<String, String> attributes) {
                        if (annotationClassName.equals(BindSqlInsert.class.getCanonicalName()) || annotationClassName.equals(BindSqlUpdate.class.getCanonicalName()) || annotationClassName.equals(BindSqlDelete.class.getCanonicalName()) || annotationClassName.equals(BindSqlSelect.class.getCanonicalName()) || annotationClassName.equals(BindContentProviderEntry.class.getCanonicalName())) {
                            if (!annotationClassName.equals(BindContentProviderEntry.class.getCanonicalName())) {
                                methodWithAnnotation.value0 = true;
                            }
                            ModelAnnotation annotation = new ModelAnnotation(annotationClassName, attributes);
                            annotationList.add(annotation);
                        }
                    }
                });
                annotationList.addAll(supportAnnotationList);
                SQLiteModelMethod currentMethod = new SQLiteModelMethod(currentDaoDefinition, element, annotationList);
                AssertKripton.assertTrueOrInvalidMethodSignException((Boolean)methodWithAnnotation.value0, currentMethod, "method must be annotated with @%s, @%s, @%s or @%s", BindSqlSelect.class.getSimpleName(), BindSqlInsert.class.getSimpleName(), BindSqlUpdate.class.getSimpleName(), BindSqlDelete.class.getSimpleName());
                this.addWithCheckMethod(currentDaoDefinition, currentMethod);
            }

            private void addWithCheckMethod(SQLiteDaoDefinition currentDaoDefinition2, SQLiteModelMethod newMethod) {
                SQLiteModelMethod oldMethod = (SQLiteModelMethod)currentDaoDefinition2.findPropertyByName(newMethod.getName());
                if (oldMethod != null && oldMethod.getParameters().size() == newMethod.getParameters().size()) {
                    boolean sameParameters = true;
                    for (int i = 0; i < oldMethod.getParameters().size(); ++i) {
                        if (((TypeName)oldMethod.getParameters().get((int)i).value1).equals(newMethod.getParameters().get((int)i).value1)) continue;
                        sameParameters = false;
                        break;
                    }
                    AssertKripton.failWithInvalidMethodSignException(sameParameters, newMethod, "conflict between generated method and declared method.", new Object[0]);
                }
                currentDaoDefinition2.add(newMethod);
            }
        });
    }

    protected SQLiteDatabaseSchema createDataSource(Element databaseSchema) {
        if (databaseSchema.getKind() != ElementKind.INTERFACE) {
            String msg = String.format("Class %s: only interfaces can be annotated with @%s annotation", databaseSchema.getSimpleName().toString(), BindDataSource.class.getSimpleName());
            throw new InvalidKindForAnnotationException(msg);
        }
        if (!databaseSchema.getSimpleName().toString().endsWith("DataSource")) {
            String msg = String.format("Interface %s marked with @%s annotation must have a typeName with suffix \"DataSource\" to be used with @BindDataSource", databaseSchema.getSimpleName().toString(), BindDataSource.class.getSimpleName());
            throw new InvalidNameException(msg);
        }
        String schemaFileName = AnnotationUtility.extractAsString(databaseSchema, BindDataSource.class, AnnotationAttributeType.FILENAME);
        int schemaVersion = AnnotationUtility.extractAsInt(databaseSchema, BindDataSource.class, AnnotationAttributeType.VERSION);
        boolean generateLog = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSource.class, AnnotationAttributeType.GENERATE_LOG);
        boolean generateSchema = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSource.class, AnnotationAttributeType.GENERATE_SCHEMA);
        boolean generateAsyncTask = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSource.class, AnnotationAttributeType.GENERATE_ASYNC_TASK);
        boolean generateCursorWrapper = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSource.class, AnnotationAttributeType.GENERATE_CURSOR_WRAPPER);
        boolean generateRx = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSource.class, AnnotationAttributeType.GENERATE_RX);
        List<String> daoIntoDataSource = AnnotationUtility.extractAsClassNameArray(elementUtils, databaseSchema, BindDataSource.class, AnnotationAttributeType.DAO_SET);
        String configCursorFactory = "com.abubusoft.kripton.android.sqlite.NoCursorFactory";
        String configDatabaseErrorHandler = "com.abubusoft.kripton.android.sqlite.NoDatabaseErrorHandler";
        String configDatabaseLifecycleHandler = "com.abubusoft.kripton.android.sqlite.NoDatabaseLifecycleHandler";
        boolean configInMemory = false;
        boolean configLogEnabled = true;
        String configPopulatorClass = NoPopulator.class.getName();
        BindDataSourceOptions dataSourceOptionsAnnotation = databaseSchema.getAnnotation(BindDataSourceOptions.class);
        if (dataSourceOptionsAnnotation != null) {
            configInMemory = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSourceOptions.class, AnnotationAttributeType.IN_MEMORY);
            configLogEnabled = AnnotationUtility.extractAsBoolean(databaseSchema, BindDataSourceOptions.class, AnnotationAttributeType.LOG_ENABLED);
            configPopulatorClass = AnnotationUtility.extractAsClassName(databaseSchema, BindDataSourceOptions.class, AnnotationAttributeType.POPULATOR);
            configCursorFactory = AnnotationUtility.extractAsClassName(databaseSchema, BindDataSourceOptions.class, AnnotationAttributeType.CURSOR_FACTORY);
            configDatabaseLifecycleHandler = AnnotationUtility.extractAsClassName(databaseSchema, BindDataSourceOptions.class, AnnotationAttributeType.DATABASE_LIFECYCLE_HANDLER);
        }
        SQLiteDatabaseSchema schema = new SQLiteDatabaseSchema((TypeElement)databaseSchema, schemaFileName, schemaVersion, generateSchema, generateLog, generateAsyncTask, generateCursorWrapper, generateRx, daoIntoDataSource, configCursorFactory, configDatabaseErrorHandler, configDatabaseLifecycleHandler, configInMemory, configLogEnabled, configPopulatorClass);
        BindContentProvider contentProviderAnnotation = databaseSchema.getAnnotation(BindContentProvider.class);
        if (contentProviderAnnotation != null) {
            schema.generateContentProvider = true;
            schema.contentProvider = new SQLiteModelContentProvider();
            schema.contentProvider.authority = contentProviderAnnotation.authority();
        } else {
            schema.generateContentProvider = false;
        }
        return schema;
    }

    public static String generateEntityName(SQLiteDaoDefinition dao, SQLiteEntity entity) {
        String entityName;
        if (entity == null) {
            M2MEntity m2mEntity = M2MEntity.extractEntityManagedByDAO((TypeElement)dao.getElement());
            entityName = m2mEntity.getSimpleName();
        } else {
            entityName = entity.getSimpleName();
        }
        return entityName;
    }

    public static String generateEntityQualifiedName(SQLiteDaoDefinition dao, SQLiteEntity entity) {
        String entityName;
        if (entity == null) {
            M2MEntity m2mEntity = M2MEntity.extractEntityManagedByDAO((TypeElement)dao.getElement());
            entityName = m2mEntity.getQualifiedName();
        } else {
            entityName = entity.getName().toString();
        }
        return entityName;
    }
}

