/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.android.annotation.BindPreference;
import com.abubusoft.kripton.android.annotation.BindPreferenceAdapter;
import com.abubusoft.kripton.android.annotation.BindSharedPreferences;
import com.abubusoft.kripton.android.sharedprefs.PreferenceType;
import com.abubusoft.kripton.annotation.BindDisabled;
import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.BindEntityBuilder;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.PropertyFactory;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.exceptions.InvalidDefinition;
import com.abubusoft.kripton.processor.sharedprefs.BindSharedPreferencesBuilder;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsEntity;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsModel;
import com.abubusoft.kripton.processor.sharedprefs.model.PrefsProperty;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class BindSharedPreferencesSubProcessor
extends BaseProcessor {
    private PrefsModel model;
    private AnnotationUtility.AnnotationFilter classAnnotationFilter = AnnotationUtility.AnnotationFilter.builder().add(BindType.class).add(BindSharedPreferences.class).build();
    private AnnotationUtility.AnnotationFilter propertyAnnotationFilter = AnnotationUtility.AnnotationFilter.builder().add(BindDisabled.class).add(BindPreference.class).add(BindPreferenceAdapter.class).build();

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotationClasses() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(BindSharedPreferences.class);
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.model = new PrefsModel();
        this.parseBindType(roundEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(BindSharedPreferences.class)) {
            AssertKripton.assertTrueOrInvalidKindForAnnotationException(element.getKind() == ElementKind.CLASS, element, BindSharedPreferences.class);
            this.analyzeSharedPreferences((TypeElement)element);
        }
        return true;
    }

    public void generateClasses() throws IOException {
        for (PrefsEntity item : this.model.getEntities()) {
            BindSharedPreferencesBuilder.generate(elementUtils, this.filer, item);
        }
    }

    private String analyzeSharedPreferences(final TypeElement sharedPreference) {
        TypeElement beanElement = sharedPreference;
        String result = beanElement.getSimpleName().toString();
        final BindEntity bindEntity = BindEntityBuilder.parse(null, sharedPreference);
        final PrefsEntity currentEntity = new PrefsEntity(beanElement.getSimpleName().toString(), beanElement, AnnotationUtility.buildAnnotationList(beanElement, this.classAnnotationFilter));
        final boolean bindAllFields = AnnotationUtility.getAnnotationAttributeAsBoolean(currentEntity, BindType.class, AnnotationAttributeType.ALL_FIELDS, Boolean.TRUE);
        PropertyUtility.buildProperties(elementUtils, currentEntity, new PropertyFactory<PrefsEntity, PrefsProperty>(){

            @Override
            public PrefsProperty createProperty(PrefsEntity entity, Element propertyElement) {
                return new PrefsProperty(currentEntity, propertyElement, AnnotationUtility.buildAnnotationList(propertyElement));
            }
        }, this.propertyAnnotationFilter, new PropertyUtility.PropertyCreatedListener<PrefsEntity, PrefsProperty>(){

            @Override
            public boolean onProperty(PrefsEntity entity, PrefsProperty property) {
                if (property.hasAnnotation(BindDisabled.class)) {
                    if (bindAllFields) {
                        return false;
                    }
                    throw new InvalidDefinition(String.format("@%s can not be used with @%s(allField=false)", BindDisabled.class.getSimpleName(), BindType.class.getSimpleName()));
                }
                if (property.getPropertyType().isArray() || property.getPropertyType().isList()) {
                    property.setPreferenceType(PreferenceType.STRING);
                } else if (property.isType(new Type[]{Boolean.TYPE, Boolean.class})) {
                    property.setPreferenceType(PreferenceType.BOOL);
                } else if (property.isType(new Type[]{Short.TYPE, Short.class})) {
                    property.setPreferenceType(PreferenceType.INT);
                } else if (property.isType(new Type[]{Character.TYPE, Character.class})) {
                    property.setPreferenceType(PreferenceType.STRING);
                } else if (property.isType(new Type[]{Integer.TYPE, Integer.class})) {
                    property.setPreferenceType(PreferenceType.INT);
                } else if (property.isType(new Type[]{Long.TYPE, Long.class})) {
                    property.setPreferenceType(PreferenceType.LONG);
                } else if (property.isType(new Type[]{Float.TYPE, Float.class})) {
                    property.setPreferenceType(PreferenceType.FLOAT);
                } else if (property.isType(new Type[]{Double.TYPE, Double.class})) {
                    property.setPreferenceType(PreferenceType.STRING);
                } else {
                    property.setPreferenceType(PreferenceType.STRING);
                }
                if (!bindAllFields && !property.hasAnnotation(BindPreference.class)) {
                    return false;
                }
                ModelAnnotation annotation = property.getAnnotation(BindPreference.class);
                if (annotation != null && !AnnotationUtility.extractAsBoolean(property, annotation, AnnotationAttributeType.ENABLED)) {
                    return false;
                }
                if (bindEntity.contains(property.getName())) {
                    BindProperty bindProperty = (BindProperty)bindEntity.get(property.getName());
                    if (bindProperty.isBindedArray() || bindProperty.isBindedCollection() || bindProperty.isBindedMap() || bindProperty.isBindedObject()) {
                        property.bindProperty = bindProperty;
                    }
                } else {
                    throw new KriptonRuntimeException(String.format("In class '%s' property '%s' has a wrong definition to create SharedPreference", sharedPreference.asType(), property.getName()));
                }
                return true;
            }
        });
        ImmutableUtility.buildConstructors(elementUtils, currentEntity);
        this.model.entityAdd(currentEntity);
        return result;
    }
}

