/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.exception.KriptonRuntimeException;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.BindEntityBuilder;
import com.abubusoft.kripton.processor.bind.BindTypeBuilder;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.bind.model.BindModel;
import com.abubusoft.kripton.processor.core.AssertKripton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class BindTypeSubProcessor
extends BaseProcessor {
    private BindModel model = new BindModel();

    @Override
    protected Set<Class<? extends Annotation>> getSupportedAnnotationClasses() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(BindType.class);
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.parseBindType(roundEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(BindType.class)) {
            Element item = element;
            AssertKripton.assertTrueOrInvalidKindForAnnotationException(item.getKind() == ElementKind.CLASS, item, BindType.class);
            BindEntityBuilder.parse(this.model, (TypeElement)item);
        }
        if (this.globalBeanElements.size() == 0) {
            BindTypeSubProcessor.info("No class with @%s annotation was found", BindType.class.getSimpleName());
        }
        try {
            this.generateClasses();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KriptonRuntimeException((Throwable)e);
        }
        return true;
    }

    private void generateClasses() throws IOException {
        Iterator<BindEntity> iterator = this.model.getEntities().iterator();
        while (iterator.hasNext()) {
            BindEntity entity;
            BindEntity item = entity = iterator.next();
            BindTypeBuilder.generate(this.filer, item);
        }
    }
}

