/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor;

import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.KriptonLiveDataManager;
import com.abubusoft.kripton.processor.KriptonProcessor;
import com.abubusoft.kripton.processor.Version;
import java.io.File;
import javax.annotation.processing.ProcessingEnvironment;

public abstract class KriptonOptions {
    public static String DEBUG = "kripton.debug";
    public static String SCHEMA_LOCATION_OPTIONS = "kripton.schemaLocation";
    public static String ANDROID_X_OPTIONS = "kripton.androidx";
    public static String schemaLocationDirectory;
    public static boolean androidX;

    public static String getSchemaLocation() {
        return schemaLocationDirectory;
    }

    public static void init(KriptonProcessor kriptonProcessor, ProcessingEnvironment processingEnv) {
        KriptonProcessor.DEBUG_MODE = KriptonProcessor.DEBUG_MODE || "true".equals(processingEnv.getOptions().get(DEBUG));
        schemaLocationDirectory = processingEnv.getOptions().get(SCHEMA_LOCATION_OPTIONS);
        if (!StringUtils.hasText((String)schemaLocationDirectory)) {
            schemaLocationDirectory = "schemas";
        }
        KriptonLiveDataManager.init(processingEnv.getOptions().get(ANDROID_X_OPTIONS));
        if (KriptonProcessor.DEBUG_MODE && !KriptonProcessor.JUNIT_TEST_MODE) {
            KriptonProcessor.info("Kripton Persistence Library v. " + Version.getVersion(), new Object[0]);
            String value = processingEnv.getOptions().get(ANDROID_X_OPTIONS);
            if (StringUtils.hasText((String)value)) {
                KriptonProcessor.info("param " + ANDROID_X_OPTIONS + " = " + value, new Object[0]);
            } else {
                KriptonProcessor.info("param " + ANDROID_X_OPTIONS + " = <unset>", new Object[0]);
            }
            KriptonProcessor.info("\tjetpack live data support is " + ("androidx.lifecycle.LiveData".equals(KriptonLiveDataManager.getInstance().getLiveDataClazz().toString()) ? "enabled" : "disabled"), new Object[0]);
            value = processingEnv.getOptions().get(SCHEMA_LOCATION_OPTIONS);
            if (StringUtils.hasText((String)value)) {
                KriptonProcessor.info("param " + SCHEMA_LOCATION_OPTIONS + " = " + value, new Object[0]);
            } else {
                KriptonProcessor.info("param " + SCHEMA_LOCATION_OPTIONS + " = <unset>", new Object[0]);
            }
            KriptonProcessor.info("\tschemas location is '" + new File(schemaLocationDirectory).getAbsoluteFile() + "'", new Object[0]);
        }
    }
}

