/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind;

import com.abubusoft.kripton.android.annotation.BindSqlType;
import com.abubusoft.kripton.annotation.Bind;
import com.abubusoft.kripton.annotation.BindAdapter;
import com.abubusoft.kripton.annotation.BindDisabled;
import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.annotation.BindXml;
import com.abubusoft.kripton.annotation.BindXmlType;
import com.abubusoft.kripton.common.CaseFormat;
import com.abubusoft.kripton.common.Converter;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.FindXmlNamespaceVisitor;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.bind.model.BindModel;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.bind.transform.ByteArrayBindTransform;
import com.abubusoft.kripton.processor.bind.transform.ObjectBindTransform;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.reflect.AnnotationUtility;
import com.abubusoft.kripton.processor.core.reflect.PropertyFactory;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.IncompatibleAnnotationException;
import com.abubusoft.kripton.processor.exceptions.IncompatibleAttributesInAnnotationException;
import com.abubusoft.kripton.processor.exceptions.InvalidDefinition;
import com.abubusoft.kripton.xml.MapEntryType;
import com.abubusoft.kripton.xml.XmlType;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class BindEntityBuilder {
    private static AnnotationUtility.AnnotationFilter classAnnotationFilter = AnnotationUtility.AnnotationFilter.builder().add(BindType.class).add(BindSqlType.class).build();
    private static AnnotationUtility.AnnotationFilter propertyAnnotationFilter = AnnotationUtility.AnnotationFilter.builder().add(Bind.class).add(BindXml.class).add(BindDisabled.class).add(BindAdapter.class).build();

    public static BindEntity parse(final BindModel model, TypeElement element) {
        Elements elementUtils = BaseProcessor.elementUtils;
        final InnerCounter counterPropertyInValue = new InnerCounter();
        final Converter typeNameConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        final TypeElement beanElement = element;
        final BindEntity currentEntity = new BindEntity(beanElement.getSimpleName().toString(), beanElement, AnnotationUtility.buildAnnotationList(element, classAnnotationFilter));
        String tagName = AnnotationUtility.extractAsString(beanElement, BindType.class, AnnotationAttributeType.VALUE);
        currentEntity.xmlInfo.label = StringUtils.hasText((String)tagName) ? tagName : (String)typeNameConverter.convert((Object)beanElement.getSimpleName().toString());
        if (element.getAnnotation(BindXmlType.class) != null) {
            FindXmlNamespaceVisitor visitor = new FindXmlNamespaceVisitor();
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                if (!BindXmlType.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                    String key = entry.getKey().getSimpleName().toString();
                    entry.getValue().accept(visitor, key);
                }
                List<Pair<String, String>> namespaces = visitor.getNamespace();
                currentEntity.xmlInfo.namespaces = namespaces;
                break;
            }
        }
        final boolean bindAllFields = AnnotationUtility.getAnnotationAttributeAsBoolean(currentEntity, BindType.class, AnnotationAttributeType.ALL_FIELDS, Boolean.TRUE);
        PropertyUtility.buildProperties(elementUtils, currentEntity, new PropertyFactory<BindEntity, BindProperty>(){

            @Override
            public BindProperty createProperty(BindEntity entity, Element propertyElement) {
                return new BindProperty(currentEntity, propertyElement, AnnotationUtility.buildAnnotationList(propertyElement));
            }
        }, propertyAnnotationFilter, new PropertyUtility.PropertyCreatedListener<BindEntity, BindProperty>(){

            @Override
            public boolean onProperty(BindEntity entity, BindProperty property) {
                String msg;
                BindTransform transform;
                boolean contextExternal;
                boolean bl = contextExternal = model == null;
                if (property.hasAnnotation(BindDisabled.class)) {
                    if (bindAllFields) {
                        return false;
                    }
                    throw new InvalidDefinition(String.format("In class '%s', @%s can not be used with @%s(allField=false)", property.getParent().getElement().asType().toString(), BindDisabled.class.getSimpleName(), BindType.class.getSimpleName()));
                }
                boolean enabled = bindAllFields;
                ModelAnnotation annotationBind = property.getAnnotation(Bind.class);
                boolean bl2 = enabled = enabled || annotationBind != null && AnnotationUtility.extractAsBoolean(property, annotationBind, AnnotationAttributeType.ENABLED);
                if (!enabled && !contextExternal) {
                    return false;
                }
                ModelAnnotation annotationBindXml = property.getAnnotation(BindXml.class);
                property.order = 0;
                property.mapKeyName = "key";
                property.mapValueName = "value";
                property.xmlInfo.labelItem = property.label = (String)typeNameConverter.convert((Object)property.getName());
                property.xmlInfo.wrappedCollection = false;
                property.xmlInfo.xmlType = XmlType.valueOf((String)XmlType.TAG.toString());
                property.xmlInfo.mapEntryType = MapEntryType.valueOf((String)MapEntryType.TAG.toString());
                if (property.getAnnotation(BindAdapter.class) != null) {
                    transform = BindTransformer.lookup(TypeUtility.typeName(property.typeAdapter.dataType));
                    if (!transform.isTypeAdapterSupported()) {
                        String msg2 = String.format("In class '%s', property '%s' uses @BindAdapter with unsupported 'dataType' '%s'", beanElement.asType().toString(), property.getName(), property.typeAdapter.dataType);
                        throw new IncompatibleAnnotationException(msg2);
                    }
                    if (property.getPropertyType().isPrimitive()) {
                        String msg3 = String.format("In class '%s', property '%s' is primitive of type '%s' and it can not be annotated with @BindAdapter", beanElement.asType().toString(), property.getName(), property.getPropertyType().getTypeName());
                        throw new IncompatibleAnnotationException(msg3);
                    }
                }
                if (annotationBind != null) {
                    String mapValueName;
                    String mapKeyName;
                    int order;
                    property.order = order = AnnotationUtility.extractAsInt(property.getElement(), Bind.class, AnnotationAttributeType.ORDER);
                    String tempName = AnnotationUtility.extractAsString(property.getElement(), Bind.class, AnnotationAttributeType.VALUE);
                    if (StringUtils.hasText((String)tempName)) {
                        property.xmlInfo.labelItem = property.label = tempName;
                    }
                    if (StringUtils.hasText((String)(mapKeyName = AnnotationUtility.extractAsString(property.getElement(), Bind.class, AnnotationAttributeType.MAP_KEY_NAME)))) {
                        property.mapKeyName = mapKeyName;
                    }
                    if (StringUtils.hasText((String)(mapValueName = AnnotationUtility.extractAsString(property.getElement(), Bind.class, AnnotationAttributeType.MAP_VALUE_NAME)))) {
                        property.mapValueName = mapValueName;
                    }
                }
                if (annotationBindXml != null) {
                    String namespace;
                    String xmlType;
                    String tempElementName;
                    String mapEntryType = AnnotationUtility.extractAsEnumerationValue(property.getElement(), BindXml.class, AnnotationAttributeType.MAP_ENTRY_TYPE);
                    if (StringUtils.hasText((String)mapEntryType)) {
                        property.xmlInfo.mapEntryType = MapEntryType.valueOf((String)mapEntryType);
                    }
                    if (StringUtils.hasText((String)(tempElementName = AnnotationUtility.extractAsString(property.getElement(), BindXml.class, AnnotationAttributeType.XML_ELEMENT_TAG)))) {
                        property.xmlInfo.labelItem = tempElementName;
                        property.xmlInfo.wrappedCollection = true;
                    }
                    if (StringUtils.hasText((String)(xmlType = AnnotationUtility.extractAsEnumerationValue(property.getElement(), BindXml.class, AnnotationAttributeType.XML_TYPE)))) {
                        property.xmlInfo.xmlType = XmlType.valueOf((String)xmlType);
                    }
                    if (StringUtils.hasText((String)(namespace = annotationBindXml.getAttribute(AnnotationAttributeType.NAMESPACE)))) {
                        if (property.xmlInfo.xmlType == XmlType.VALUE || property.xmlInfo.xmlType == XmlType.VALUE_CDATA) {
                            String msg4 = String.format("In class '%s', property '%s', defined as xml value, can not be used with a namespace", beanElement.asType().toString(), property.getName());
                            throw new IncompatibleAttributesInAnnotationException(msg4);
                        }
                        property.xmlInfo.namespace = namespace;
                    }
                }
                if (property.xmlInfo.xmlType == XmlType.ATTRIBUTE) {
                    transform = BindTransformer.lookup(property.getPropertyType().getTypeName());
                    if (property.isBindedArray() && !(transform instanceof ByteArrayBindTransform)) {
                        msg = String.format("In class '%s', property '%s' is an array and it can not be mapped in a xml attribute", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (property.isBindedCollection()) {
                        msg = String.format("In class '%s', property '%s' is a collection and it can not be mapped in a xml attribute", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (property.isBindedMap()) {
                        msg = String.format("In class '%s', property '%s' is an map and it can not be mapped in a xml attribute", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (transform != null && transform instanceof ObjectBindTransform) {
                        msg = String.format("In class '%s', property '%s' is an object and it can not be mapped in a xml attribute", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                }
                if (property.xmlInfo.xmlType == XmlType.VALUE || property.xmlInfo.xmlType == XmlType.VALUE_CDATA) {
                    counterPropertyInValue.inc();
                    transform = BindTransformer.lookup(property.getPropertyType().getTypeName());
                    if (property.isBindedArray() && !(transform instanceof ByteArrayBindTransform)) {
                        msg = String.format("In class '%s', property '%s' is an array and it can not be mapped in a xml value", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (property.isBindedCollection()) {
                        msg = String.format("In class '%s', property '%s' is a collection and it can not be mapped in a xml value", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (property.isBindedMap()) {
                        msg = String.format("In class '%s', property '%s' is a map and it can not be mapped in a xml value", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                    if (transform != null && transform instanceof ObjectBindTransform) {
                        msg = String.format("In class '%s', property '%s' is an object and it can not be mapped in a xml value", beanElement.asType().toString(), property.getName());
                        throw new IncompatibleAttributesInAnnotationException(msg);
                    }
                }
                if (counterPropertyInValue.value() > 1) {
                    String msg5 = String.format("In class '%s', property '%s' and other properties are mapped in a xml value, but only one property for class can be a xml value", beanElement.asType().toString(), property.getName());
                    throw new IncompatibleAttributesInAnnotationException(msg5);
                }
                property.bindedObject = BindTransformer.isBindedObject(property);
                if (property.bindedObject && contextExternal) {
                    property.inCollection = true;
                }
                return true;
            }
        });
        ImmutableUtility.buildConstructors(elementUtils, currentEntity);
        if (model != null) {
            model.entityAdd(currentEntity);
        }
        return currentEntity;
    }

    public static class InnerCounter {
        int counter;

        public void inc() {
            ++this.counter;
        }

        public int value() {
            return this.counter;
        }
    }
}

