/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind;

import com.abubusoft.kripton.AbstractMapper;
import com.abubusoft.kripton.annotation.BindMap;
import com.abubusoft.kripton.annotation.BindType;
import com.abubusoft.kripton.common.Pair;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.BaseProcessor;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.JavaWriterHelper;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.core.ImmutableUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.sqlite.core.JavadocUtility;
import com.abubusoft.kripton.processor.utils.AnnotationProcessorUtilis;
import com.abubusoft.kripton.xml.XMLParser;
import com.abubusoft.kripton.xml.XMLSerializer;
import com.abubusoft.kripton.xml.XmlPullParser;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor7;
import javax.lang.model.util.Elements;

public abstract class BindTypeBuilder {
    protected static AbstractElementVisitor7<Void, VisitResult> visitor = new AbstractElementVisitor7<Void, VisitResult>(){

        @Override
        public Void visitPackage(PackageElement e, VisitResult p) {
            System.out.println("visitPackage " + e.asType());
            return null;
        }

        @Override
        public Void visitType(TypeElement e, VisitResult p) {
            System.out.println("visitType " + e.asType());
            if (e.getSuperclass() instanceof DeclaredType) {
                DeclaredType superclassDeclaredType = (DeclaredType)e.getSuperclass();
                System.out.println("visitType parent " + superclassDeclaredType.getTypeArguments().size());
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, VisitResult p) {
            System.out.println("visitVariable " + e.asType());
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, VisitResult p) {
            System.out.println("visitExecutable " + e.asType());
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, VisitResult p) {
            System.out.println("visitTypeParameter " + e.asType());
            return null;
        }
    };
    protected static final String PREFIX = "";
    protected static final String SUFFIX = "BindMap";

    public static String generate(Filer filer, BindEntity item) throws IOException {
        Elements elementUtils = BaseProcessor.elementUtils;
        String beanClassName = item.getSimpleName().toString();
        boolean needSuffix = true;
        if (beanClassName.endsWith(SUFFIX)) {
            needSuffix = false;
        }
        String className = PREFIX + beanClassName + (needSuffix ? SUFFIX : PREFIX);
        PackageElement pkg = elementUtils.getPackageOf((Element)item.getElement());
        String packageName = pkg.isUnnamed() ? PREFIX : pkg.getQualifiedName().toString();
        AnnotationProcessorUtilis.infoOnGeneratedClasses(BindType.class, packageName, className);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addAnnotation(AnnotationSpec.builder(BindMap.class).addMember("value", "$T.class", new Object[]{TypeUtility.typeName(((TypeElement)item.getElement()).asType())}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(TypeUtility.parameterizedTypeName(TypeUtility.className(AbstractMapper.class), TypeUtility.typeName(((TypeElement)item.getElement()).asType())));
        BindTypeContext context = new BindTypeContext(builder, TypeUtility.typeName(packageName, className), Modifier.PRIVATE);
        builder.addJavadoc("This class is binder map for $T\n\n", new Object[]{item.getElement()});
        JavadocUtility.generateJavadocGeneratedBy(builder);
        builder.addJavadoc("@see $T\n", new Object[]{item.getElement()});
        Collections.sort(item.getCollection(), new Comparator<BindProperty>(){

            @Override
            public int compare(BindProperty lhs, BindProperty rhs) {
                int c1 = lhs.order - rhs.order;
                if (c1 != 0) {
                    return c1;
                }
                return lhs.getName().compareTo(rhs.getName());
            }
        });
        BindTypeBuilder.generateSerializeOnJackson(context, item);
        BindTypeBuilder.generateSerializeOnJacksonAsString(context, item);
        Collections.sort(item.getCollection(), new Comparator<BindProperty>(){

            @Override
            public int compare(BindProperty lhs, BindProperty rhs) {
                int c1 = lhs.xmlInfo.xmlType.ordinal() - rhs.xmlInfo.xmlType.ordinal();
                if (c1 != 0) {
                    return c1;
                }
                c1 = lhs.order - rhs.order;
                if (c1 != 0) {
                    return c1;
                }
                return lhs.label.compareTo(rhs.label);
            }
        });
        BindTypeBuilder.generateSerializeOnXml(context, item);
        BindTypeBuilder.generateParseOnJackson(context, item);
        BindTypeBuilder.generateParseOnJacksonAsString(context, item);
        BindTypeBuilder.generateParseOnXml(context, item);
        TypeSpec typeSpec = builder.build();
        JavaWriterHelper.writeJava2File(filer, packageName, typeSpec);
        return className;
    }

    private static void generateParseOnXml(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"parseOnXml").addJavadoc("parse xml\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(XMLParser.class), "xmlParser", new Modifier[0]).addParameter(TypeUtility.typeName(Integer.TYPE), "currentEventType", new Modifier[0]).returns(TypeUtility.typeName(entity.getElement())).addException(Exception.class);
        boolean mutableObject = entity.isMutablePojo();
        if (mutableObject) {
            methodBuilder.addStatement("$T instance = new $T()", new Object[]{entity.getElement(), entity.getElement()});
        } else {
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addStatement("int eventType = currentEventType", new Object[0]);
        methodBuilder.addStatement("boolean read=true", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.beginControlFlow("if (currentEventType == 0)", new Object[0]);
        methodBuilder.addStatement("eventType = xmlParser.next()", new Object[0]);
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("eventType = xmlParser.getEventType()", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("String currentTag = xmlParser.getName().toString()", new Object[0]);
        methodBuilder.addStatement("String elementName = currentTag", new Object[0]);
        BindTypeBuilder.generateParseOnXmlAttributes(context, methodBuilder, entity);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("//sub-elements\n", new Object[0]);
        methodBuilder.beginControlFlow("while (xmlParser.hasNext() && elementName!=null)", new Object[0]);
        methodBuilder.beginControlFlow("if (read)", new Object[0]);
        methodBuilder.addStatement("eventType = xmlParser.next()", new Object[0]);
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("eventType = xmlParser.getEventType()", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("read=true", new Object[0]);
        methodBuilder.beginControlFlow("switch(eventType)$>", new Object[0]);
        methodBuilder.addCode("case $T.START_TAG:\n$>", new Object[]{XmlPullParser.class});
        BindTypeBuilder.generateParserOnXmlStartElement(context, methodBuilder, "instance", "xmlParser", entity);
        methodBuilder.addStatement("$<break", new Object[0]);
        methodBuilder.addCode("case $T.END_TAG:\n$>", new Object[]{XmlPullParser.class});
        BindTypeBuilder.generateParserOnXmlEndElement(context, methodBuilder, "instance", "xmlParser", entity);
        methodBuilder.addStatement("$<break", new Object[0]);
        methodBuilder.addCode("case $T.CDSECT:\n", new Object[]{XmlPullParser.class});
        methodBuilder.addCode("case $T.TEXT:\n$>", new Object[]{XmlPullParser.class});
        BindTypeBuilder.generateParserOnXmlCharacters(context, methodBuilder, "instance", "xmlParser", entity);
        methodBuilder.addStatement("$<break", new Object[0]);
        methodBuilder.addCode("default:\n$>", new Object[0]);
        methodBuilder.addStatement("$<break", new Object[0]);
        methodBuilder.addCode("$<", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (!mutableObject) {
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "instance", true);
        }
        methodBuilder.addStatement("return instance", new Object[0]);
        context.builder.addMethod(methodBuilder.build());
    }

    private static void generateParserOnXmlEndElement(BindTypeContext context, MethodSpec.Builder methodBuilder, String instanceName, String parserName, BindEntity entity) {
        methodBuilder.beginControlFlow("if (elementName.equals($L.getName()))", new Object[]{parserName});
        methodBuilder.addStatement("currentTag = elementName", new Object[0]);
        methodBuilder.addStatement("elementName = null", new Object[0]);
        methodBuilder.endControlFlow();
    }

    private static void generateParseOnXmlAttributes(BindTypeContext context, MethodSpec.Builder methodBuilder, BindEntity entity) {
        int count = 0;
        for (BindProperty property : entity.getCollection()) {
            if (property.xmlInfo.xmlType != XmlType.ATTRIBUTE) continue;
            ++count;
        }
        if (count > 0) {
            methodBuilder.addCode("\n// attributes \n", new Object[0]);
            methodBuilder.addStatement("String attributeName = null", new Object[0]);
            methodBuilder.addStatement("int attributesCount = xmlParser.getAttributeCount();", new Object[0]);
            methodBuilder.beginControlFlow("for (int attributeIndex = 0; attributeIndex < attributesCount; attributeIndex++)", new Object[0]);
            methodBuilder.addStatement("attributeName = xmlParser.getAttributeName(attributeIndex)", new Object[0]);
            methodBuilder.beginControlFlow("switch(attributeName)$>", new Object[0]);
            for (BindProperty property : entity.getCollection()) {
                if (property.xmlInfo.xmlType != XmlType.ATTRIBUTE) continue;
                methodBuilder.addCode("case $S:\n$>", new Object[]{BindProperty.xmlName(property)});
                BindTransform bindTransform = BindTransformer.lookup(property);
                methodBuilder.addCode("// field $L (mapped by $S)\n", new Object[]{property.getName(), BindProperty.xmlName(property)});
                bindTransform.generateParseOnXml(context, methodBuilder, "xmlParser", property.getPropertyType().getTypeName(), "instance", property);
                methodBuilder.addStatement("$<break", new Object[0]);
            }
            methodBuilder.addCode("default:\n$>", new Object[0]);
            methodBuilder.addStatement("$<break$<", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addCode("// No attributes found\n", new Object[0]);
        }
    }

    private static void generateParserOnXmlStartElement(BindTypeContext context, MethodSpec.Builder methodBuilder, String instanceName, String parserName, BindEntity entity) {
        BindTransform bindTransform;
        methodBuilder.addStatement("currentTag = xmlParser.getName().toString()", new Object[0]);
        int count = 0;
        for (BindProperty property : entity.getCollection()) {
            if (property.xmlInfo.xmlType != XmlType.TAG || (bindTransform = BindTransformer.lookup(property)) == null) continue;
            ++count;
        }
        if (count > 0) {
            methodBuilder.beginControlFlow("switch(currentTag)$>", new Object[0]);
            for (BindProperty property : entity.getCollection()) {
                if (property.xmlInfo.xmlType != XmlType.TAG || (bindTransform = BindTransformer.lookup(property)) == null) continue;
                methodBuilder.addCode("case $S:\n$>", new Object[]{BindProperty.xmlName(property)});
                methodBuilder.addCode("// property $L (mapped on $S)\n", new Object[]{property.getName(), BindProperty.xmlName(property)});
                bindTransform.generateParseOnXml(context, methodBuilder, "xmlParser", property.getPropertyType().getTypeName(), "instance", property);
                methodBuilder.addStatement("$<break", new Object[0]);
            }
            methodBuilder.addCode("default:\n$>", new Object[0]);
            methodBuilder.addStatement("$<break", new Object[0]);
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addCode("// No property to manage here\n", new Object[0]);
        }
    }

    private static void generateParserOnXmlCharacters(BindTypeContext context, MethodSpec.Builder methodBuilder, String instanceName, String parserName, BindEntity entity) {
        int count = 0;
        for (BindProperty property : entity.getCollection()) {
            if (property.xmlInfo.xmlType != XmlType.VALUE && property.xmlInfo.xmlType != XmlType.VALUE_CDATA) continue;
            ++count;
            methodBuilder.beginControlFlow("if (elementName!=null && $L.hasText())", new Object[]{parserName});
            methodBuilder.addCode("// property $L\n", new Object[]{property.getName()});
            BindTransform bindTransform = BindTransformer.lookup(property);
            bindTransform.generateParseOnXml(context, methodBuilder, parserName, property.getPropertyType().getTypeName(), "instance", property);
            methodBuilder.endControlFlow();
        }
        if (count == 0) {
            methodBuilder.addCode("// no property is binded to VALUE o CDATA ", new Object[0]);
        }
    }

    private static void generateParseOnJackson(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"parseOnJackson").addJavadoc("parse with jackson\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(JsonParser.class), "jacksonParser", new Modifier[0]).returns(TypeUtility.typeName(entity.getElement())).addException(Exception.class);
        boolean mutableObject = entity.isMutablePojo();
        if (mutableObject) {
            methodBuilder.addStatement("$T instance = new $T()", new Object[]{entity.getElement(), entity.getElement()});
        } else {
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addStatement("String fieldName", new Object[0]);
        methodBuilder.beginControlFlow("if (jacksonParser.currentToken() == null)", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (jacksonParser.currentToken() != $T.START_OBJECT)", new Object[]{JsonToken.class});
        methodBuilder.addStatement("jacksonParser.skipChildren()", new Object[0]);
        if (!mutableObject) {
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "instance", true);
        }
        methodBuilder.addStatement("return instance", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("while (jacksonParser.nextToken() != $T.END_OBJECT)", new Object[]{JsonToken.class});
        methodBuilder.addStatement("fieldName = jacksonParser.getCurrentName()", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
        if (entity.getCollection().size() > 0) {
            methodBuilder.addCode("\n// Parse fields:\n", new Object[0]);
            methodBuilder.beginControlFlow("switch (fieldName)$>", new Object[0]);
            for (BindProperty item : entity.getCollection()) {
                BindTransform bindTransform = BindTransformer.lookup(item);
                methodBuilder.addCode("case $S:\n$>", new Object[]{item.label});
                methodBuilder.addCode("// field $L (mapped with $S)\n", new Object[]{item.getName(), item.label});
                bindTransform.generateParseOnJackson(context, methodBuilder, "jacksonParser", item.getPropertyType().getTypeName(), "instance", item);
                methodBuilder.addCode("$<break;\n", new Object[0]);
            }
            methodBuilder.addCode("default:$>\n", new Object[0]);
            methodBuilder.addStatement("jacksonParser.skipChildren()", new Object[0]);
            methodBuilder.addCode("$<break;", new Object[0]);
            methodBuilder.addCode("$<", new Object[0]);
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addCode("\n// No field to parse\n", new Object[0]);
        }
        methodBuilder.endControlFlow();
        if (!mutableObject) {
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "instance", true);
        }
        methodBuilder.addStatement("return instance", new Object[0]);
        context.builder.addMethod(methodBuilder.build());
    }

    private static void generateParseOnJacksonAsString(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"parseOnJacksonAsString").addJavadoc("parse with jackson\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(JsonParser.class), "jacksonParser", new Modifier[0]).returns(TypeUtility.typeName(entity.getElement())).addException(Exception.class);
        boolean mutableObject = entity.isMutablePojo();
        if (mutableObject) {
            methodBuilder.addStatement("$T instance = new $T()", new Object[]{entity.getElement(), entity.getElement()});
        } else {
            ImmutableUtility.generateImmutableVariableInit(entity, methodBuilder);
        }
        methodBuilder.addStatement("String fieldName", new Object[0]);
        methodBuilder.beginControlFlow("if (jacksonParser.getCurrentToken() == null)", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (jacksonParser.getCurrentToken() != $T.START_OBJECT)", new Object[]{JsonToken.class});
        methodBuilder.addStatement("jacksonParser.skipChildren()", new Object[0]);
        if (!mutableObject) {
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "instance", true);
        }
        methodBuilder.addStatement("return instance", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("while (jacksonParser.nextToken() != $T.END_OBJECT)", new Object[]{JsonToken.class});
        methodBuilder.addStatement("fieldName = jacksonParser.getCurrentName()", new Object[0]);
        methodBuilder.addStatement("jacksonParser.nextToken()", new Object[0]);
        if (entity.getCollection().size() > 0) {
            methodBuilder.addCode("\n// Parse fields:\n", new Object[0]);
            methodBuilder.beginControlFlow("switch (fieldName)$>", new Object[0]);
            for (BindProperty item : entity.getCollection()) {
                BindTransform bindTransform = BindTransformer.lookup(item);
                methodBuilder.addCode("case $S:\n$>", new Object[]{item.label});
                methodBuilder.addCode("// field $L (mapped with $S)\n", new Object[]{item.getName(), item.label});
                bindTransform.generateParseOnJacksonAsString(context, methodBuilder, "jacksonParser", item.getPropertyType().getTypeName(), "instance", item);
                methodBuilder.addCode("$<break;\n", new Object[0]);
            }
            methodBuilder.addCode("default:$>\n", new Object[0]);
            methodBuilder.addStatement("jacksonParser.skipChildren()", new Object[0]);
            methodBuilder.addCode("$<break;", new Object[0]);
            methodBuilder.addCode("$<", new Object[0]);
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addCode("\n// No field to parse\n", new Object[0]);
        }
        methodBuilder.endControlFlow();
        if (!mutableObject) {
            ImmutableUtility.generateImmutableEntityCreation(entity, methodBuilder, "instance", true);
        }
        methodBuilder.addStatement("return instance", new Object[0]);
        context.builder.addMethod(methodBuilder.build());
    }

    private static void generateSerializeOnJackson(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"serializeOnJackson").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(entity.getElement()), "object", new Modifier[0]).addParameter(TypeUtility.typeName(JsonGenerator.class), "jacksonSerializer", new Modifier[0]).returns(Integer.TYPE).addException(Exception.class);
        methodBuilder.addStatement("jacksonSerializer.writeStartObject()", new Object[0]);
        methodBuilder.addStatement("int fieldCount=0", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("// Serialized Field:\n\n", new Object[0]);
        for (BindProperty item : entity.getCollection()) {
            BindTransform bindTransform = BindTransformer.lookup(item);
            methodBuilder.addCode("// field $L (mapped with $S)\n", new Object[]{item.getName(), item.label});
            bindTransform.generateSerializeOnJackson(context, methodBuilder, "jacksonSerializer", item.getPropertyType().getTypeName(), "object", item);
            methodBuilder.addCode("\n", new Object[0]);
        }
        methodBuilder.addStatement("jacksonSerializer.writeEndObject()", new Object[0]);
        methodBuilder.addStatement("return fieldCount", new Object[0]);
        context.builder.addMethod(methodBuilder.build());
    }

    private static void generateSerializeOnJacksonAsString(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"serializeOnJacksonAsString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(entity.getElement()), "object", new Modifier[0]).addParameter(TypeUtility.typeName(JsonGenerator.class), "jacksonSerializer", new Modifier[0]).returns(Integer.TYPE).addException(Exception.class);
        methodBuilder.addStatement("jacksonSerializer.writeStartObject()", new Object[0]);
        methodBuilder.addStatement("int fieldCount=0", new Object[0]);
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("// Serialized Field:\n\n", new Object[0]);
        for (BindProperty item : entity.getCollection()) {
            BindTransform bindTransform = BindTransformer.lookup(item);
            methodBuilder.addCode("// field $L (mapped with $S)\n", new Object[]{item.getName(), item.label});
            bindTransform.generateSerializeOnJacksonAsString(context, methodBuilder, "jacksonSerializer", item.getPropertyType().getTypeName(), "object", item);
            methodBuilder.addCode("\n", new Object[0]);
        }
        methodBuilder.addStatement("jacksonSerializer.writeEndObject()", new Object[0]);
        methodBuilder.addStatement("return fieldCount", new Object[0]);
        context.builder.addMethod(methodBuilder.build());
    }

    private static void generateSerializeOnXml(BindTypeContext context, BindEntity entity) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"serializeOnXml").addJavadoc("method for xml serialization\n", new Object[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeUtility.typeName(entity.getElement()), "object", new Modifier[0]).addParameter(TypeUtility.typeName(XMLSerializer.class), "xmlSerializer", new Modifier[0]).addParameter(TypeUtility.typeName(Integer.TYPE), "currentEventType", new Modifier[0]).returns(Void.TYPE).addException(Exception.class);
        methodBuilder.beginControlFlow("if (currentEventType == 0)", new Object[0]);
        methodBuilder.addStatement("xmlSerializer.writeStartElement(\"$L\")", new Object[]{entity.xmlInfo.label});
        for (Pair<String, String> namespace : entity.xmlInfo.namespaces) {
            if (StringUtils.hasText((String)((String)namespace.value0))) {
                methodBuilder.addStatement("xmlSerializer.writeAttribute(\"\", $S, $S)", new Object[]{"xmlns:" + (String)namespace.value0, namespace.value1});
                continue;
            }
            methodBuilder.addStatement("xmlSerializer.writeAttribute(\"\", $S, $S)", new Object[]{"xmlns", namespace.value1});
        }
        methodBuilder.endControlFlow();
        methodBuilder.addCode("\n", new Object[0]);
        methodBuilder.addCode("// Persisted fields:\n\n", new Object[0]);
        for (BindProperty item : entity.getCollection()) {
            BindTransform bindTransform = BindTransformer.lookup(item);
            methodBuilder.addCode("// field $L (mapped with $S)\n", new Object[]{item.getName(), BindProperty.xmlName(item)});
            if (item.hasTypeAdapter()) {
                methodBuilder.addCode("// field trasformation $L $L \n", new Object[]{item.typeAdapter.dataType, item.typeAdapter.adapterClazz});
            }
            bindTransform.generateSerializeOnXml(context, methodBuilder, "xmlSerializer", item.getPropertyType().getTypeName(), "object", item);
            methodBuilder.addCode("\n", new Object[0]);
        }
        methodBuilder.beginControlFlow("if (currentEventType == 0)", new Object[0]);
        methodBuilder.addStatement("xmlSerializer.writeEndElement()", new Object[0]);
        methodBuilder.endControlFlow();
        context.builder.addMethod(methodBuilder.build());
    }

    public static class VisitResult {
        public TypeMirror rawType;
        public List<? extends TypeMirror> argumentTypes;
        public Elements elementUtils;

        public VisitResult(Elements elementUtils) {
            this.elementUtils = elementUtils;
        }
    }
}

