/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind;

import com.abubusoft.kripton.BinderUtils;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class BindTypeContext {
    public TypeSpec.Builder builder;
    public Set<String> alreadyGeneratedMethods;
    public Modifier[] modifiers;
    private TypeName beanTypeName;

    public BindTypeContext(TypeSpec.Builder builder, TypeName beanTypeName, Modifier ... modifiers) {
        this.builder = builder;
        this.beanTypeName = beanTypeName;
        this.alreadyGeneratedMethods = new HashSet<String>();
        this.modifiers = modifiers;
    }

    public String getBindMapperName(BindTypeContext context, TypeName typeName) {
        ClassName bindMapperName;
        Converter format = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
        String simpleName = (String)format.convert((Object)TypeUtility.simpleName((TypeName)(bindMapperName = TypeUtility.mergeTypeNameWithSuffix(typeName, "BindMap"))));
        if (!this.alreadyGeneratedMethods.contains(simpleName)) {
            this.alreadyGeneratedMethods.add(simpleName);
            if (bindMapperName.equals((Object)this.beanTypeName)) {
                context.builder.addField(FieldSpec.builder((TypeName)bindMapperName, (String)simpleName, (Modifier[])this.modifiers).addJavadoc("$T", new Object[]{bindMapperName}).initializer("this", new Object[0]).build());
            } else {
                context.builder.addField(FieldSpec.builder((TypeName)bindMapperName, (String)simpleName, (Modifier[])this.modifiers).addJavadoc("$T", new Object[]{bindMapperName}).initializer("$T.mapperFor($T.class)", new Object[]{BinderUtils.class, typeName}).build());
            }
        }
        return simpleName;
    }
}

