/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.model;

import com.abubusoft.kripton.android.annotation.BindSqlAdapter;
import com.abubusoft.kripton.annotation.BindAdapter;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.bind.model.BindEntity;
import com.abubusoft.kripton.processor.core.AnnotationAttributeType;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.ModelAnnotation;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.ModelProperty;
import com.abubusoft.kripton.processor.core.ModelType;
import com.abubusoft.kripton.processor.core.TypeAdapterHelper;
import com.abubusoft.kripton.xml.MapEntryType;
import com.abubusoft.kripton.xml.XmlType;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Element;

public class BindProperty
extends ModelProperty {
    public boolean inCollection = false;
    public boolean nullable = true;
    public boolean bindedObject;
    public int order;
    public XmlInfo xmlInfo = new XmlInfo();
    public JacksonInfo jacksonInfo = new JacksonInfo();
    public String mapKeyName;
    public String label;
    public String mapValueName;

    public static BindPropertyBuilder builder(TypeName rawTypeName, BindProperty property) {
        return new BindPropertyBuilder(rawTypeName, property);
    }

    public static BindPropertyBuilder builder(TypeName parameterTypeName) {
        return new BindPropertyBuilder(parameterTypeName);
    }

    public BindProperty(BindEntity entity, Element element, List<ModelAnnotation> modelAnnotations) {
        super(entity, element, modelAnnotations);
        ModelAnnotation annotationBindAdapter = this.getAnnotation(BindAdapter.class);
        ModelAnnotation annotationBindSqlAdapter = this.getAnnotation(BindSqlAdapter.class);
        AssertKripton.assertTrueOfInvalidDefinition(annotationBindAdapter == null && annotationBindSqlAdapter == null || annotationBindAdapter == null != (annotationBindSqlAdapter == null), this, "@BindAdapter and @BindSqlAdapter can not be used together");
        if (annotationBindAdapter == null) {
            annotationBindAdapter = annotationBindSqlAdapter;
        }
        if (annotationBindAdapter != null) {
            this.typeAdapter.adapterClazz = annotationBindAdapter.getAttributeAsClassName(AnnotationAttributeType.ADAPTER);
            this.typeAdapter.dataType = TypeAdapterHelper.detectDestinationType(entity.getElement(), this.typeAdapter.adapterClazz);
            this.checkTypeAdapter(entity, element.asType(), this.typeAdapter, annotationBindAdapter);
        }
    }

    public boolean isInCollection() {
        return this.inCollection;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public static String xmlName(BindProperty property) {
        String namespace = property.xmlInfo.namespace;
        String label = property.label;
        if (StringUtils.hasText((String)namespace)) {
            return namespace + ":" + label;
        }
        return label;
    }

    public boolean isBindedObject() {
        return this.bindedObject;
    }

    public boolean isBindedCollection() {
        return this.propertyType.isCollection();
    }

    public boolean isBindedArray() {
        return this.propertyType.isArray();
    }

    public boolean isBindedMap() {
        return this.propertyType.isMap();
    }

    public static String xmlNameForItem(BindProperty property) {
        String namespace = property.xmlInfo.namespace;
        String label = property.xmlInfo.labelItem;
        if (StringUtils.hasText((String)namespace)) {
            return namespace + ":" + label;
        }
        return label;
    }

    public class XmlInfo {
        public MapEntryType mapEntryType = MapEntryType.TAG;
        public String labelItem;
        public boolean wrappedCollection;
        public XmlType xmlType = XmlType.TAG;
        public String namespace;

        public boolean isWrappedCollection() {
            return this.wrappedCollection;
        }
    }

    public class JacksonInfo {
    }

    public static class BindPropertyBuilder {
        protected BindProperty parentProperty;
        protected TypeName rawTypeName;
        protected XmlType xmlType;
        private String label;
        private boolean nullable;
        protected boolean inCollection;
        private ModelEntity parent;

        public BindPropertyBuilder inCollection(boolean inCollection) {
            this.inCollection = inCollection;
            return this;
        }

        public BindPropertyBuilder(TypeName rawTypeName, BindProperty property) {
            this.rawTypeName = rawTypeName;
            if (property != null) {
                this.parentProperty = property;
                this.parent = property.getParent();
                this.nullable = property.nullable;
                this.xmlType = property.xmlInfo.xmlType;
                this.label = property.label;
            }
            this.inCollection = true;
        }

        public BindPropertyBuilder(TypeName parameterTypeName) {
            this.rawTypeName = parameterTypeName;
            this.parentProperty = null;
            this.nullable = true;
            this.inCollection = true;
        }

        public BindProperty build() {
            BindProperty property = new BindProperty(null, null, null);
            property.propertyType = new ModelType(this.rawTypeName);
            property.order = this.parentProperty != null ? this.parentProperty.order : 0;
            property.inCollection = this.inCollection;
            property.label = this.label;
            property.xmlInfo.xmlType = this.xmlType;
            property.xmlInfo.labelItem = null;
            property.nullable = this.nullable;
            return property;
        }

        public BindPropertyBuilder xmlType(XmlType xmlType) {
            this.xmlType = xmlType;
            return this;
        }

        public BindPropertyBuilder elementName(String label) {
            this.label = label;
            return this;
        }

        public BindPropertyBuilder label(String elementTag) {
            this.label = elementTag;
            return this;
        }

        public BindPropertyBuilder nullable(boolean value) {
            this.nullable = value;
            return this;
        }
    }
}

