/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.CollectionUtils;
import com.abubusoft.kripton.common.StringUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransformer;
import com.abubusoft.kripton.processor.core.ModelEntity;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.processor.exceptions.KriptonClassNotFoundException;
import com.abubusoft.kripton.xml.XmlAttributeUtils;
import com.abubusoft.kripton.xml.XmlPullParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractCollectionBindTransform
extends AbstractBindTransform {
    private static final String EMPTY_COLLECTION_ATTRIBUTE_NAME = "emptyCollection";
    protected CollectionType collectionType;
    protected Class<?> collectionClazz = List.class;
    protected Class<?> defaultClazz = ArrayList.class;

    @Override
    public boolean isTypeAdapterSupported() {
        return false;
    }

    public AbstractCollectionBindTransform(ParameterizedTypeName clazz, CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public AbstractCollectionBindTransform(TypeName clazz, CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    protected Class<?> defineCollectionClass(ParameterizedTypeName collectionTypeName) {
        if (collectionTypeName.rawType.toString().startsWith(this.collectionClazz.getCanonicalName())) {
            return this.defaultClazz;
        }
        if (collectionTypeName.rawType.toString().startsWith(SortedMap.class.getCanonicalName())) {
            return TreeMap.class;
        }
        if (collectionTypeName.rawType.toString().startsWith(SortedSet.class.getCanonicalName())) {
            return TreeSet.class;
        }
        try {
            return Class.forName(collectionTypeName.rawType.toString());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new KriptonClassNotFoundException(e);
        }
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, false);
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, true);
    }

    public void generateParseOnJacksonInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        TypeName elementTypeName = this.extractTypeParameterName(property);
        methodBuilder.beginControlFlow("if ($L.currentToken()==$T.START_ARRAY)", new Object[]{parserName, JsonToken.class});
        if (this.collectionType == CollectionType.ARRAY) {
            methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{ArrayList.class, elementTypeName.box(), ArrayList.class});
        } else {
            ParameterizedTypeName collectionTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
            methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{this.defineCollectionClass(collectionTypeName), elementTypeName.box(), this.defineCollectionClass(collectionTypeName)});
        }
        methodBuilder.addStatement("$T item=$L", new Object[]{elementTypeName.box(), this.DEFAULT_VALUE});
        if (onString) {
            methodBuilder.addStatement("String tempValue=null", new Object[0]);
        }
        BindTransform transform = BindTransformer.lookup(elementTypeName);
        BindProperty elementProperty = BindProperty.builder(elementTypeName, property).inCollection(true).nullable(false).build();
        methodBuilder.beginControlFlow("while ($L.nextToken() != $T.END_ARRAY)", new Object[]{parserName, JsonToken.class});
        if (onString) {
            methodBuilder.addStatement("tempValue=$L.getValueAsString()", new Object[]{parserName});
            methodBuilder.beginControlFlow("if ($L.currentToken()==$T.VALUE_STRING && \"null\".equals(tempValue))", new Object[]{parserName, JsonToken.class});
        } else {
            methodBuilder.beginControlFlow("if ($L.currentToken()==$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        methodBuilder.addStatement("item=$L", new Object[]{this.DEFAULT_VALUE});
        methodBuilder.nextControlFlow("else", new Object[0]);
        if (onString) {
            transform.generateParseOnJacksonAsString(context, methodBuilder, parserName, null, "item", elementProperty);
        } else {
            transform.generateParseOnJackson(context, methodBuilder, parserName, null, "item", elementProperty);
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("collection.add(item)", new Object[0]);
        methodBuilder.endControlFlow();
        if (this.collectionType == CollectionType.ARRAY) {
            if (TypeUtility.isTypePrimitive(elementTypeName)) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TTypeArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName.box()});
            } else if (TypeUtility.isTypeWrappedPrimitive(elementTypeName)) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName});
            } else {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.asArray(collection, new $T[collection.size()])"), new Object[]{CollectionUtils.class, elementTypeName});
            }
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "collection"), new Object[0]);
        }
        if (onString) {
            methodBuilder.nextControlFlow("else if ($L.currentToken()==$T.VALUE_STRING && !$T.hasText($L.getValueAsString()))", new Object[]{parserName, JsonToken.class, StringUtils.class, parserName});
            if (this.collectionType == CollectionType.ARRAY) {
                methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{ArrayList.class, elementTypeName.box(), ArrayList.class});
            } else {
                ParameterizedTypeName collectionTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
                methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{this.defineCollectionClass(collectionTypeName), elementTypeName.box(), this.defineCollectionClass(collectionTypeName)});
            }
            if (this.collectionType == CollectionType.ARRAY) {
                if (TypeUtility.isTypePrimitive(elementTypeName)) {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TTypeArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName.box()});
                } else if (TypeUtility.isTypeWrappedPrimitive(elementTypeName)) {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName.box()});
                } else {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.asArray(collection, new $T[collection.size()])"), new Object[]{CollectionUtils.class, elementTypeName});
                }
            } else {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "collection"), new Object[0]);
            }
        }
        methodBuilder.endControlFlow();
    }

    protected TypeName convert(ModelEntity modelEntity, ClassName elementTypeName) {
        return elementTypeName;
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName elementTypeName = this.extractTypeParameterName(property);
        methodBuilder.beginControlFlow("", new Object[0]);
        switch (this.collectionType) {
            case ARRAY: {
                methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{ArrayList.class, elementTypeName.box(), ArrayList.class});
                break;
            }
            case LIST: 
            case SET: {
                ParameterizedTypeName collectionTypeName = (ParameterizedTypeName)property.getPropertyType().getTypeName();
                methodBuilder.addStatement("$T<$T> collection=new $T<>()", new Object[]{this.defineCollectionClass(collectionTypeName), elementTypeName.box(), this.defineCollectionClass(collectionTypeName)});
            }
        }
        methodBuilder.addStatement("$T item", new Object[]{elementTypeName.box()});
        BindTransform transform = BindTransformer.lookup(elementTypeName);
        BindProperty elementProperty = BindProperty.builder(elementTypeName, property).inCollection(true).build();
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.beginControlFlow("while ($L.nextTag() != $T.END_TAG && $L.getName().toString().equals($S))", new Object[]{parserName, XmlPullParser.class, parserName, property.xmlInfo.labelItem});
        } else {
            methodBuilder.addCode("// add first element\n", new Object[0]);
            methodBuilder.addStatement("item=$L", new Object[]{this.DEFAULT_VALUE});
            methodBuilder.beginControlFlow("if ($L.isEmptyElement())", new Object[]{parserName});
            methodBuilder.addCode("// if there's a an empty collection it marked with attribute emptyCollection\n", new Object[0]);
            methodBuilder.beginControlFlow("if ($T.getAttributeAsBoolean($L, $S, false)==false)", new Object[]{XmlAttributeUtils.class, parserName, EMPTY_COLLECTION_ATTRIBUTE_NAME});
            methodBuilder.addStatement("collection.add(item)", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
            methodBuilder.nextControlFlow("else", new Object[0]);
            transform.generateParseOnXml(context, methodBuilder, parserName, null, "item", elementProperty);
            methodBuilder.addStatement("collection.add(item)", new Object[0]);
            methodBuilder.endControlFlow();
            methodBuilder.beginControlFlow("while ($L.nextTag() != $T.END_TAG && $L.getName().toString().equals($S))", new Object[]{parserName, XmlPullParser.class, parserName, BindProperty.xmlName(property)});
        }
        methodBuilder.beginControlFlow("if ($L.isEmptyElement())", new Object[]{parserName});
        methodBuilder.addStatement("item=$L", new Object[]{this.DEFAULT_VALUE});
        methodBuilder.addStatement("$L.nextTag()", new Object[]{parserName});
        methodBuilder.nextControlFlow("else", new Object[0]);
        transform.generateParseOnXml(context, methodBuilder, parserName, null, "item", elementProperty);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("collection.add(item)", new Object[0]);
        methodBuilder.endControlFlow();
        if (this.collectionType == CollectionType.ARRAY) {
            if (TypeUtility.isTypePrimitive(elementTypeName)) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TTypeArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName.box()});
            } else if (TypeUtility.isTypeWrappedPrimitive(elementTypeName)) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.as$TArray(collection)"), new Object[]{CollectionUtils.class, elementTypeName});
            } else {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.asArray(collection, new $T[collection.size()])"), new Object[]{CollectionUtils.class, elementTypeName});
            }
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "collection"), new Object[0]);
        }
        if (!property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addStatement("read=false", new Object[0]);
        }
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJacksonInternal(context, methodBuilder, serializerName, beanClass, beanName, property, false);
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJacksonInternal(context, methodBuilder, serializerName, beanClass, beanName, property, true);
    }

    void generateSerializeOnJacksonInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        TypeName elementTypeName = this.extractTypeParameterName(property);
        methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (this.collectionType == CollectionType.LIST) {
            methodBuilder.addStatement("int n=$L.size()", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addStatement("$T item", new Object[]{elementTypeName});
        } else if (this.collectionType == CollectionType.ARRAY) {
            methodBuilder.addStatement("int n=$L.length", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addStatement("$T item", new Object[]{elementTypeName});
        } else if (onString) {
            methodBuilder.addStatement("int n=$L.size()", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        BindTransform transform = BindTransformer.lookup(elementTypeName);
        BindProperty elementProperty = BindProperty.builder(elementTypeName, property).inCollection(true).nullable(false).build();
        methodBuilder.addCode("// write wrapper tag\n", new Object[0]);
        methodBuilder.addStatement("$L.writeFieldName($S)", new Object[]{serializerName, property.label});
        if (onString) {
            methodBuilder.beginControlFlow("if (n>0)", new Object[0]);
        }
        methodBuilder.addStatement("$L.writeStartArray()", new Object[]{serializerName});
        if (this.collectionType == CollectionType.SET) {
            methodBuilder.beginControlFlow("for ($T item: $L)", new Object[]{elementTypeName, PropertyUtility.getter(beanName, beanClass, property)});
        } else if (this.collectionType == CollectionType.LIST) {
            methodBuilder.beginControlFlow("for (int i=0; i<n; i++)", new Object[0]);
            methodBuilder.addStatement("item=$L.get(i)", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        } else if (this.collectionType == CollectionType.ARRAY) {
            methodBuilder.beginControlFlow("for (int i=0; i<n; i++)", new Object[0]);
            methodBuilder.addStatement("item=$L[i]", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (elementProperty.getPropertyType().isArray() || !TypeUtility.isTypePrimitive(elementTypeName)) {
            methodBuilder.beginControlFlow("if (item==null)", new Object[0]);
            if (onString) {
                methodBuilder.addStatement("$L.writeString(\"null\")", new Object[]{serializerName});
            } else {
                methodBuilder.addStatement("$L.writeNull()", new Object[]{serializerName});
            }
            methodBuilder.nextControlFlow("else", new Object[0]);
        }
        if (onString) {
            transform.generateSerializeOnJacksonAsString(context, methodBuilder, serializerName, null, "item", elementProperty);
        } else {
            transform.generateSerializeOnJackson(context, methodBuilder, serializerName, null, "item", elementProperty);
        }
        if (elementProperty.getPropertyType().isArray() || !TypeUtility.isTypePrimitive(elementTypeName)) {
            methodBuilder.endControlFlow();
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$L.writeEndArray()", new Object[]{serializerName});
        if (onString) {
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("$L.writeString(\"\")", new Object[]{serializerName});
            methodBuilder.endControlFlow();
        }
        methodBuilder.endControlFlow();
    }

    private TypeName extractTypeParameterName(BindProperty property) {
        return property.getPropertyType().getTypeParameter();
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName elementTypeName = this.extractTypeParameterName(property);
        methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        switch (this.collectionType) {
            case LIST: {
                methodBuilder.addStatement("int n=$L.size()", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
                methodBuilder.addStatement("$T item", new Object[]{elementTypeName});
                break;
            }
            case ARRAY: {
                methodBuilder.addStatement("int n=$L.length", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
                methodBuilder.addStatement("$T item", new Object[]{elementTypeName});
                break;
            }
            case SET: {
                methodBuilder.addStatement("int n=$L.size()", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            }
        }
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addCode("// write wrapper tag\n", new Object[0]);
            methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
        }
        BindTransform transform = BindTransformer.lookup(elementTypeName);
        BindProperty elementProperty = BindProperty.builder(elementTypeName, property).inCollection(true).elementName(BindProperty.xmlNameForItem(property)).build();
        switch (this.collectionType) {
            case SET: {
                methodBuilder.beginControlFlow("for ($T item: $L)", new Object[]{elementTypeName, PropertyUtility.getter(beanName, beanClass, property)});
                break;
            }
            case LIST: {
                methodBuilder.beginControlFlow("for (int i=0; i<n; i++)", new Object[0]);
                methodBuilder.addStatement("item=$L.get(i)", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
                break;
            }
            case ARRAY: {
                methodBuilder.beginControlFlow("for (int i=0; i<n; i++)", new Object[0]);
                methodBuilder.addStatement("item=$L[i]", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
            }
        }
        if (!TypeUtility.isTypePrimitive(elementTypeName)) {
            methodBuilder.beginControlFlow("if (item==null)", new Object[0]);
            methodBuilder.addStatement("$L.writeEmptyElement($S)", new Object[]{serializerName, BindProperty.xmlNameForItem(property)});
            methodBuilder.nextControlFlow("else", new Object[0]);
            transform.generateSerializeOnXml(context, methodBuilder, serializerName, null, "item", elementProperty);
            methodBuilder.endControlFlow();
        } else {
            transform.generateSerializeOnXml(context, methodBuilder, serializerName, null, "item", elementProperty);
        }
        methodBuilder.endControlFlow();
        if (property.xmlInfo.isWrappedCollection()) {
            methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
        } else {
            methodBuilder.addCode("// to distinguish between first empty element and empty collection, we write an attribute emptyCollection\n", new Object[0]);
            methodBuilder.beginControlFlow("if (n==0)", new Object[0]);
            methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlNameForItem(property)});
            methodBuilder.addStatement("$L.writeAttribute($S, $S)", new Object[]{serializerName, EMPTY_COLLECTION_ATTRIBUTE_NAME, "true"});
            methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
            methodBuilder.endControlFlow();
        }
        methodBuilder.endControlFlow();
    }

    public static enum CollectionType {
        ARRAY,
        LIST,
        SET;

    }
}

