/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.ArrayBindTransform;
import com.abubusoft.kripton.processor.bind.transform.BigDecimalBindTransform;
import com.abubusoft.kripton.processor.bind.transform.BigIntegerBindTransform;
import com.abubusoft.kripton.processor.bind.transform.BindTransform;
import com.abubusoft.kripton.processor.bind.transform.BooleanBindTransform;
import com.abubusoft.kripton.processor.bind.transform.ByteArrayBindTransform;
import com.abubusoft.kripton.processor.bind.transform.ByteBindTransform;
import com.abubusoft.kripton.processor.bind.transform.CalendarBindTransform;
import com.abubusoft.kripton.processor.bind.transform.CharacterBindTransform;
import com.abubusoft.kripton.processor.bind.transform.CurrencyBindTransform;
import com.abubusoft.kripton.processor.bind.transform.DateBindTransform;
import com.abubusoft.kripton.processor.bind.transform.DoubleBindTransform;
import com.abubusoft.kripton.processor.bind.transform.EnumBindTransform;
import com.abubusoft.kripton.processor.bind.transform.FloatBindTransform;
import com.abubusoft.kripton.processor.bind.transform.IntegerBindTransform;
import com.abubusoft.kripton.processor.bind.transform.ListBindTransformation;
import com.abubusoft.kripton.processor.bind.transform.LocaleBindTransform;
import com.abubusoft.kripton.processor.bind.transform.LongBindTransform;
import com.abubusoft.kripton.processor.bind.transform.MapBindTransformation;
import com.abubusoft.kripton.processor.bind.transform.ObjectBindTransform;
import com.abubusoft.kripton.processor.bind.transform.SQLDateBindTransform;
import com.abubusoft.kripton.processor.bind.transform.SQLTimeBindTransform;
import com.abubusoft.kripton.processor.bind.transform.SetBindTransformation;
import com.abubusoft.kripton.processor.bind.transform.ShortBindTransform;
import com.abubusoft.kripton.processor.bind.transform.StringBindTransform;
import com.abubusoft.kripton.processor.bind.transform.TimeZoneBindTransform;
import com.abubusoft.kripton.processor.bind.transform.UrlBindTransform;
import com.abubusoft.kripton.processor.core.AssertKripton;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BindTransformer {
    private static final Map<TypeName, BindTransform> cache = new ConcurrentHashMap<TypeName, BindTransform>();
    static final Set<String> unsupportedPackage = new HashSet<String>(Arrays.asList("java.", "javax.", "android.", "androidx."));

    public static BindTransform lookup(BindProperty property) {
        TypeName typeName = property.getPropertyType().getTypeName();
        if (property.hasTypeAdapter()) {
            typeName = TypeUtility.typeName(property.typeAdapter.dataType);
        }
        return BindTransformer.lookup(typeName);
    }

    public static boolean isBindedObject(TypeName typeName) {
        BindTransform t = BindTransformer.lookup(typeName);
        return t != null && t instanceof ObjectBindTransform;
    }

    public static boolean isBindedObject(BindProperty property) {
        BindTransform t = BindTransformer.lookup(property);
        return t != null && t instanceof ObjectBindTransform;
    }

    static boolean isInUnsupportedPackage(TypeName typeName) {
        for (String item : unsupportedPackage) {
            if (!typeName.toString().startsWith(item)) continue;
            return true;
        }
        return false;
    }

    public static BindTransform lookup(TypeName typeName) {
        BindTransform transform = cache.get(typeName);
        if (transform != null) {
            return transform;
        }
        transform = BindTransformer.getTransform(typeName);
        AssertKripton.assertTrueOrUnsupportedFieldTypeException(transform != null, typeName);
        cache.put(typeName, transform);
        return transform;
    }

    public static void checkIfIsInUnsupportedPackage(TypeName typeName) {
        BindTransform transform = BindTransformer.lookup(typeName);
        AssertKripton.assertTrueOrUnsupportedFieldTypeException(!transform.getClass().getName().equals(ObjectBindTransform.class.getName()) || !BindTransformer.isInUnsupportedPackage(typeName), typeName);
    }

    static BindTransform getTransform(TypeName typeName) {
        String name;
        if (typeName.isPrimitive()) {
            return BindTransformer.getPrimitiveTransform(typeName);
        }
        if (typeName instanceof ArrayTypeName) {
            ArrayTypeName typeNameArray = (ArrayTypeName)typeName;
            if (TypeUtility.isEquals(typeNameArray.componentType, Byte.TYPE.toString())) {
                return new ByteArrayBindTransform();
            }
            return new ArrayBindTransform(typeNameArray.componentType, typeNameArray.componentType.isPrimitive());
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (TypeUtility.isList((TypeName)parameterizedTypeName.rawType)) {
                return new ListBindTransformation(parameterizedTypeName);
            }
            if (TypeUtility.isSet((TypeName)parameterizedTypeName.rawType)) {
                return new SetBindTransformation(parameterizedTypeName);
            }
            if (TypeUtility.isMap((TypeName)parameterizedTypeName.rawType)) {
                return new MapBindTransformation(parameterizedTypeName);
            }
        }
        if ((name = typeName.toString()).startsWith("java.lang")) {
            return BindTransformer.getLanguageTransform(typeName);
        }
        if (name.startsWith("java.util")) {
            return BindTransformer.getUtilTransform(typeName);
        }
        if (name.startsWith("java.math")) {
            return BindTransformer.getMathTransform(typeName);
        }
        if (name.startsWith("java.net")) {
            return BindTransformer.getNetTransform(typeName);
        }
        if (name.startsWith("java.sql")) {
            return BindTransformer.getSqlTransform(typeName);
        }
        if (TypeUtility.isEnum(typeName)) {
            return new EnumBindTransform(typeName);
        }
        return new ObjectBindTransform();
    }

    static BindTransform getSqlTransform(TypeName typeName) {
        if (Time.class.getName().equals(typeName.toString())) {
            return new SQLTimeBindTransform();
        }
        if (Date.class.getName().equals(typeName.toString())) {
            return new SQLDateBindTransform();
        }
        return null;
    }

    static BindTransform getNetTransform(TypeName typeName) {
        if (URL.class.getName().equals(typeName.toString())) {
            return new UrlBindTransform();
        }
        return null;
    }

    static BindTransform getMathTransform(TypeName typeName) {
        if (BigDecimal.class.getName().equals(typeName.toString())) {
            return new BigDecimalBindTransform();
        }
        if (BigInteger.class.getName().equals(typeName.toString())) {
            return new BigIntegerBindTransform();
        }
        return null;
    }

    static BindTransform getPrimitiveTransform(TypeName type) {
        if (Integer.TYPE.toString().equals(type.toString())) {
            return new IntegerBindTransform(false);
        }
        if (Boolean.TYPE.toString().equals(type.toString())) {
            return new BooleanBindTransform(false);
        }
        if (Long.TYPE.toString().equals(type.toString())) {
            return new LongBindTransform(false);
        }
        if (Double.TYPE.toString().equals(type.toString())) {
            return new DoubleBindTransform(false);
        }
        if (Float.TYPE.toString().equals(type.toString())) {
            return new FloatBindTransform(false);
        }
        if (Short.TYPE.toString().equals(type.toString())) {
            return new ShortBindTransform(false);
        }
        if (Byte.TYPE.toString().equals(type.toString())) {
            return new ByteBindTransform(false);
        }
        if (Character.TYPE.toString().equals(type.toString())) {
            return new CharacterBindTransform(false);
        }
        return null;
    }

    static BindTransform getLanguageTransform(TypeName type) {
        String typeName = type.toString();
        if (Integer.class.getCanonicalName().equals(typeName)) {
            return new IntegerBindTransform(true);
        }
        if (Boolean.class.getCanonicalName().equals(typeName)) {
            return new BooleanBindTransform(true);
        }
        if (Long.class.getCanonicalName().equals(typeName)) {
            return new LongBindTransform(true);
        }
        if (Double.class.getCanonicalName().equals(typeName)) {
            return new DoubleBindTransform(true);
        }
        if (Float.class.getCanonicalName().equals(typeName)) {
            return new FloatBindTransform(true);
        }
        if (Short.class.getCanonicalName().equals(typeName)) {
            return new ShortBindTransform(true);
        }
        if (Byte.class.getCanonicalName().equals(typeName)) {
            return new ByteBindTransform(true);
        }
        if (Character.class.getCanonicalName().equals(typeName)) {
            return new CharacterBindTransform(true);
        }
        if (String.class.getCanonicalName().equals(typeName)) {
            return new StringBindTransform();
        }
        return null;
    }

    static BindTransform getUtilTransform(TypeName type) {
        String typeName = type.toString();
        if (java.util.Date.class.getCanonicalName().equals(typeName)) {
            return new DateBindTransform();
        }
        if (Locale.class.getCanonicalName().equals(typeName)) {
            return new LocaleBindTransform();
        }
        if (Currency.class.getCanonicalName().equals(typeName)) {
            return new CurrencyBindTransform();
        }
        if (Calendar.class.getCanonicalName().equals(typeName)) {
            return new CalendarBindTransform();
        }
        if (TimeZone.class.getCanonicalName().equals(typeName)) {
            return new TimeZoneBindTransform();
        }
        return null;
    }
}

