/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.Base64Utils;
import com.abubusoft.kripton.common.TypeAdapterUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class ByteArrayBindTransform
extends AbstractBindTransform {
    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, false);
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return true;
    }

    public void generateParseOnJacksonInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            if (onString) {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.decode($L.getValueAsString()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), Base64Utils.class, parserName});
            } else {
                methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L.getBinaryValue())"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName});
            }
        } else if (onString) {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.decode($L.getValueAsString())"), new Object[]{Base64Utils.class, parserName});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.getBinaryValue()"), new Object[]{parserName});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateParseOnJacksonInternal(context, methodBuilder, parserName, beanClass, beanName, property, true);
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.hasTypeAdapter()) {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.decode($L.getAttributeValue(attributeIndex)))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), Base64Utils.class, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L.getElementAsBinary())"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.decode($L.getText()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), Base64Utils.class, parserName});
                    break;
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.decode($L.getAttributeValue(attributeIndex))"), new Object[]{Base64Utils.class, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.getElementAsBinary()"), new Object[]{parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.decode($L.getText())"), new Object[]{Base64Utils.class, parserName});
                    break;
                }
            }
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            if (property.isInCollection()) {
                methodBuilder.addStatement("$L.writeBinary($T.toData($T.class, $L))", new Object[]{serializerName, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            } else {
                methodBuilder.addStatement("$L.writeBinaryField($S, $T.toData($T.class, $L))", new Object[]{serializerName, property.label, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            }
        } else if (property.isInCollection()) {
            methodBuilder.addStatement("$L.writeBinary($L)", new Object[]{serializerName, PropertyUtility.getter(beanName, beanClass, property)});
        } else {
            methodBuilder.addStatement("$L.writeBinaryField($S, $L)", new Object[]{serializerName, property.label, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJackson(context, methodBuilder, serializerName, beanClass, beanName, property);
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null)", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.hasTypeAdapter()) {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.encode($T.toData($T.class, $L)))", new Object[]{serializerName, BindProperty.xmlName(property), Base64Utils.class, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeBinary($T.toData($T.class, $L))", new Object[]{serializerName, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeBinary($T.toData($T.class, $L))", new Object[]{serializerName, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.encode($L))", new Object[]{serializerName, BindProperty.xmlName(property), Base64Utils.class, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeBinary($L)", new Object[]{serializerName, PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeBinary($L)", new Object[]{serializerName, PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        }
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }
}

