/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class ObjectBindTransform
extends AbstractBindTransform {
    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName typeName = property.getPropertyType().getTypeName();
        String bindName = context.getBindMapperName(context, typeName);
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.parseOnXml(xmlParser, eventType)"), new Object[]{bindName});
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return false;
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName typeName = property.getPropertyType().getTypeName();
        String bindName = context.getBindMapperName(context, typeName);
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
        methodBuilder.addStatement("$L.serializeOnXml($L, xmlSerializer, $L)", new Object[]{bindName, PropertyUtility.getter(beanName, beanClass, property), 2});
        methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }

    void generateSerializeInternal(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property, boolean onString) {
        TypeName typeName = property.getPropertyType().getTypeName();
        String bindName = context.getBindMapperName(context, typeName);
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (!property.isInCollection()) {
            methodBuilder.addStatement("$L.writeFieldName($S)", new Object[]{serializerName, property.label});
        }
        if (onString) {
            methodBuilder.beginControlFlow("if ($L.serializeOnJacksonAsString($L, jacksonSerializer)==0)", new Object[]{bindName, PropertyUtility.getter(beanName, beanClass, property)});
            methodBuilder.addStatement("$L.writeNullField($S)", new Object[]{serializerName, property.label});
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addStatement("$L.serializeOnJackson($L, jacksonSerializer)", new Object[]{bindName, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeInternal(context, methodBuilder, serializerName, beanClass, beanName, property, false);
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeInternal(context, methodBuilder, serializerName, beanClass, beanName, property, true);
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName typeName = property.getPropertyType().getTypeName();
        String bindName = context.getBindMapperName(context, typeName);
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()==$T.START_OBJECT)", new Object[]{parserName, JsonToken.class});
        }
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.parseOnJackson(jacksonParser)"), new Object[]{bindName});
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        TypeName typeName = property.getPropertyType().getTypeName();
        String bindName = context.getBindMapperName(context, typeName);
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()==$T.START_OBJECT || $L.currentToken()==$T.VALUE_STRING)", new Object[]{parserName, JsonToken.class, parserName, JsonToken.class});
        }
        methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.parseOnJacksonAsString(jacksonParser)"), new Object[]{bindName});
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }
}

