/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.TypeAdapterUtils;
import com.abubusoft.kripton.escape.StringEscapeUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class StringBindTransform
extends AbstractBindTransform {
    @Override
    public boolean isTypeAdapterSupported() {
        return true;
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L.getText())"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.getText()"), new Object[]{parserName});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $L.getText())"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), parserName});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$L.getText()"), new Object[]{parserName});
        }
        methodBuilder.endControlFlow();
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.unescapeXml($L.getAttributeValue(attributeIndex)))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), StringEscapeUtils.class, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.unescapeXml($L.getElementText()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), StringEscapeUtils.class, parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.unescapeXml($L.getText()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), StringEscapeUtils.class, parserName});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.unescapeXml($L.getAttributeValue(attributeIndex))"), new Object[]{StringEscapeUtils.class, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.unescapeXml($L.getElementText())"), new Object[]{StringEscapeUtils.class, parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.unescapeXml($L.getText())"), new Object[]{StringEscapeUtils.class, parserName});
                }
            }
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            if (property.isInCollection()) {
                methodBuilder.addStatement("$L.writeString($T.toData($T.class, $L))", new Object[]{serializerName, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            } else {
                methodBuilder.addStatement("$L.writeStringField($S, $T.toData($T.class, $L))", new Object[]{serializerName, property.label, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            }
        } else if (property.isInCollection()) {
            methodBuilder.addStatement("$L.writeString($L)", new Object[]{serializerName, PropertyUtility.getter(beanName, beanClass, property)});
        } else {
            methodBuilder.addStatement("$L.writeStringField($S, $L)", new Object[]{serializerName, property.label, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJackson(context, methodBuilder, serializerName, beanClass, beanName, property);
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (!property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null)", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.hasTypeAdapter()) {
            methodBuilder.addCode("// using type adapter $L\n", new Object[]{property.typeAdapter.adapterClazz});
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.escapeXml10($T.toData($T.class, $L)))", new Object[]{serializerName, BindProperty.xmlName(property), StringEscapeUtils.class, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.toData($T.class, $L)))", new Object[]{serializerName, StringEscapeUtils.class, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.toData($T.class, $L)))", new Object[]{serializerName, StringEscapeUtils.class, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.escapeXml10($T.toData($T.class, $L)))", new Object[]{serializerName, StringEscapeUtils.class, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.escapeXml10($L))", new Object[]{serializerName, BindProperty.xmlName(property), StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($L))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($L))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.escapeXml10($L))", new Object[]{serializerName, StringEscapeUtils.class, PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        }
        if (!property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }
}

