/*
 * Decompiled with CFR 0.152.
 */
package com.abubusoft.kripton.processor.bind.transform;

import com.abubusoft.kripton.common.TypeAdapterUtils;
import com.abubusoft.kripton.escape.StringEscapeUtils;
import com.abubusoft.kripton.processor.bind.BindTypeContext;
import com.abubusoft.kripton.processor.bind.model.BindProperty;
import com.abubusoft.kripton.processor.bind.transform.AbstractBindTransform;
import com.abubusoft.kripton.processor.core.reflect.PropertyUtility;
import com.abubusoft.kripton.processor.core.reflect.TypeUtility;
import com.abubusoft.kripton.xml.XmlType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class WrappedBindTransform
extends AbstractBindTransform {
    protected Class<?> utilClazz;

    public WrappedBindTransform(Class<?> utilClazz) {
        this.utilClazz = utilClazz;
    }

    @Override
    public boolean isTypeAdapterSupported() {
        return true;
    }

    @Override
    public void generateParseOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read($L.getText()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.utilClazz, parserName});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read($L.getText())"), new Object[]{this.utilClazz, parserName});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L.currentToken()!=$T.VALUE_NULL)", new Object[]{parserName, JsonToken.class});
        }
        if (property.hasTypeAdapter()) {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read($L.getText()))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.utilClazz, parserName});
        } else {
            methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read($L.getText())"), new Object[]{this.utilClazz, parserName});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateParseOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String parserName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.hasTypeAdapter()) {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read($L.getAttributeValue(attributeIndex)))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.utilClazz, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read($T.unescapeXml($L.getElementText())))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.utilClazz, StringEscapeUtils.class, parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.toJava($T.class, $T.read($T.unescapeXml($L.getText())))"), new Object[]{TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), this.utilClazz, StringEscapeUtils.class, parserName});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read($L.getAttributeValue(attributeIndex))"), new Object[]{this.utilClazz, parserName});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read($T.unescapeXml($L.getElementText()))"), new Object[]{this.utilClazz, StringEscapeUtils.class, parserName});
                    break;
                }
                case VALUE: 
                case VALUE_CDATA: {
                    methodBuilder.addStatement(PropertyUtility.setter(beanClass, beanName, property, "$T.read($T.unescapeXml($L.getText()))"), new Object[]{this.utilClazz, StringEscapeUtils.class, parserName});
                    break;
                }
            }
        }
    }

    @Override
    public void generateSerializeOnJackson(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        if (property.isNullable()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isProperty()) {
            methodBuilder.addStatement("fieldCount++", new Object[0]);
        }
        if (property.hasTypeAdapter()) {
            if (property.isInCollection()) {
                methodBuilder.addStatement("$L.writeString($T.write($T.toData($T.class, $L)))", new Object[]{serializerName, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            } else {
                methodBuilder.addStatement("$L.writeStringField($S, $T.write($T.toData($T.class, $L)))", new Object[]{serializerName, property.label, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
            }
        } else if (property.isInCollection()) {
            methodBuilder.addStatement("$L.writeString($T.write($L))", new Object[]{serializerName, this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
        } else {
            methodBuilder.addStatement("$L.writeStringField($S, $T.write($L))", new Object[]{serializerName, property.label, this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.isNullable()) {
            methodBuilder.endControlFlow();
        }
    }

    @Override
    public void generateSerializeOnJacksonAsString(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        this.generateSerializeOnJackson(context, methodBuilder, serializerName, beanClass, beanName, property);
    }

    @Override
    public void generateSerializeOnXml(BindTypeContext context, MethodSpec.Builder methodBuilder, String serializerName, TypeName beanClass, String beanName, BindProperty property) {
        XmlType xmlType = property.xmlInfo.xmlType;
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.beginControlFlow("if ($L!=null) ", new Object[]{PropertyUtility.getter(beanName, beanClass, property)});
        }
        if (property.hasTypeAdapter()) {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.escapeXml10($T.write($T.toData($T.class, $L))))", new Object[]{serializerName, BindProperty.xmlName(property), StringEscapeUtils.class, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.write($T.toData($T.class, $L))))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.write($T.toData($T.class, $L))))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.escapeXml10($T.write($T.toData($T.class, $L))))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, TypeAdapterUtils.class, TypeUtility.typeName(property.typeAdapter.adapterClazz), PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        } else {
            switch (xmlType) {
                case ATTRIBUTE: {
                    methodBuilder.addStatement("$L.writeAttribute($S, $T.write($L))", new Object[]{serializerName, BindProperty.xmlName(property), this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case TAG: {
                    methodBuilder.addStatement("$L.writeStartElement($S)", new Object[]{serializerName, BindProperty.xmlName(property)});
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.write($L)))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
                    methodBuilder.addStatement("$L.writeEndElement()", new Object[]{serializerName});
                    break;
                }
                case VALUE: {
                    methodBuilder.addStatement("$L.writeCharacters($T.escapeXml10($T.write($L)))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
                    break;
                }
                case VALUE_CDATA: {
                    methodBuilder.addStatement("$L.writeCData($T.escapeXml10($T.write($L)))", new Object[]{serializerName, StringEscapeUtils.class, this.utilClazz, PropertyUtility.getter(beanName, beanClass, property)});
                }
            }
        }
        if (property.isNullable() && !property.isInCollection()) {
            methodBuilder.endControlFlow();
        }
    }
}

